/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.price.local.service.register.item;

import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDimensionItemDto;
import com.biz.crm.mdm.business.price.sdk.enums.FindPriceUserTypeEnum;
import com.biz.crm.mdm.business.price.sdk.enums.PriceDimensionEnum;
import com.biz.crm.mdm.business.price.sdk.register.UserSearchPriceDimensionItemRegister;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalRelaOrgVo;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TerminalPriceDimensionItemRegister
implements UserSearchPriceDimensionItemRegister {
    @Autowired(required=false)
    private TerminalVoService terminalVoService;

    public String getCode() {
        return FindPriceUserTypeEnum.TERMINAL.getDictCode();
    }

    public List<SearchPriceDimensionItemDto> findSearchPriceDimensionItems(String userCode) {
        SearchPriceDimensionItemDto cur;
        if (StringUtils.isBlank((CharSequence)userCode)) {
            return Lists.newLinkedList();
        }
        List terminalVoList = this.terminalVoService.findMainDetailsByTerminalCodes((List)Lists.newArrayList((Object[])new String[]{userCode}));
        if (CollectionUtils.isEmpty((Collection)terminalVoList)) {
            return Lists.newLinkedList();
        }
        Optional optional = terminalVoList.stream().findFirst();
        if (!optional.isPresent()) {
            return Lists.newLinkedList();
        }
        LinkedList dimensionItems = Lists.newLinkedList();
        SearchPriceDimensionItemDto item = new SearchPriceDimensionItemDto();
        item.setDimensionCode(PriceDimensionEnum.TERMINAL.getDictCode());
        item.setRelateCodeSet((Set)Sets.newHashSet((Object[])new String[]{userCode}));
        dimensionItems.add(item);
        TerminalVo terminalVo = (TerminalVo)optional.get();
        if (CollectionUtils.isNotEmpty((Collection)terminalVo.getOrgList())) {
            cur = new SearchPriceDimensionItemDto();
            cur.setDimensionCode(PriceDimensionEnum.ORG.getDictCode());
            cur.setRelateCodeSet(terminalVo.getOrgList().stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getOrgCode())).map(TerminalRelaOrgVo::getOrgCode).collect(Collectors.toSet()));
            dimensionItems.add(cur);
        }
        if (StringUtils.isNotBlank((CharSequence)terminalVo.getChannel())) {
            cur = new SearchPriceDimensionItemDto();
            cur.setDimensionCode(PriceDimensionEnum.CHANNEL.getDictCode());
            cur.setRelateCodeSet((Set)Sets.newHashSet((Object[])new String[]{terminalVo.getChannel()}));
            dimensionItems.add(cur);
        }
        return dimensionItems;
    }
}

