package com.biz.crm.mdm.business.price.sdk.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.Set;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 询价model-dto
 *
 * @author sunx
 * @date 2022/1/5
 */
@Data
@ApiModel("询价model-dto")
public class PriceModelDto {
  /** 价格类型编码 */
  @ApiModelProperty("价格类型编码")
  private String typeCode;
  /** 租户编号 */
  @ApiModelProperty("租户编号")
  private String tenantCode;
  /** 删除标记 */
  @ApiModelProperty("删除标记")
  private String delFlag;
  /** 价格绑定维度，商品维度 */
  @ApiModelProperty("价格绑定维度")
  private String dimensionCode;
  /** 价格绑定维度源数据编码集合,如商品编码集合 */
  @ApiModelProperty("价格绑定维度源数据编码集合")
  private Set<String> relateCodeSet;
  /** relateCodeJoin编码集合 */
  @ApiModelProperty("relateCodeJoin编码集合")
  private Set<String> relateCodeJoinSet;
  /** 询价时间 */
  @ApiModelProperty("询价时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date searchTime;
}
