package com.biz.crm.mdm.business.price.sdk.register;

import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDimensionItemDto;
import java.util.List;

/**
 * 各个用户类型根据业务主键获取可用的维护配置信息注册器
 *
 * @author sunx
 * @date 2022/3/15
 */
public interface UserSearchPriceDimensionItemRegister {
  /**
   * 用户类型，如经销商 终端等 FindPriceUserTypeEnum key
   *
   * @see com.biz.crm.mdm.business.price.sdk.enums.FindPriceUserTypeEnum
   * @return
   */
  String getCode();

  /**
   * 根据用户业务主键获取询价维度信息
   *
   * @param userCode 经销商编码、终端编码等
   * @return
   */
  List<SearchPriceDimensionItemDto> findSearchPriceDimensionItems(String userCode);
}
