package com.biz.crm.mdm.business.price.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 价格维护主信息vo
 *
 * @author sunx
 * @date 2021-12-30 17:43:58
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "价格维护主信息Vo")
public class PriceVo extends TenantFlagOpVo {
  /** 价格编码 */
  @ApiModelProperty("价格编码")
  private String priceCode;

  /** 价格类型编码 */
  @ApiModelProperty("价格类型编码")
  private String typeCode;

  /** 定价维度编码 */
  @ApiModelProperty("定价维度编码")
  private String typeDetailCode;

  /** 价格 */
  @ApiModelProperty("价格")
  private BigDecimal price;

  /** 开始时间 */
  @ApiModelProperty("开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date beginTime;

  /** 结束时间 */
  @ApiModelProperty("结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date endTime;

  /** 价格设置维度配置明细 */
  @ApiModelProperty("价格设置维度配置明细")
  private List<PriceDimensionVo> dimensionList;
}
