package com.biz.crm.mdm.business.price.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Set;
import lombok.Data;

/**
 * 价格维护主信息分页查询dto
 *
 * @author sunx
 * @date 2021-12-30 17:43:57
 */
@Data
@ApiModel(value = "PricePaginationDto", description = "价格维护主信息分页查询dto")
public class PricePaginationDto extends TenantFlagOpDto {
  /** 价格编码 */
  @ApiModelProperty("价格编码")
  private String priceCode;
  /** 价格类型编码 */
  @ApiModelProperty("价格类型编码")
  private String typeCode;
  /** 价格类型名称 */
  @ApiModelProperty("价格类型名称")
  private String typeName;
  /** 商品编码 */
  @ApiModelProperty("商品编码")
  private String productCode;
  /** 商品名称 */
  @ApiModelProperty("商品名称")
  private String productName;
  /** 商品编码 */
  @ApiModelProperty("商品编码集合")
  private Set<String> productCodeSet;
  /** 生效状态 */
  @ApiModelProperty(
      "生效状态,EffectiveStatusEnum,"
          + "  DEFAULT(\"default\", \"default\", \"未生效\", \"0\"),\n"
          + "  ACTIVE(\"active\", \"active\", \"生效中\", \"1\"),\n"
          + "  OVERDUE(\"overdue\", \"overdue\", \"已过期\", \"2\")")
  private String effectiveStatus;
}
