package com.biz.crm.mdm.business.price.sdk.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.List;
import java.util.Set;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 询价dto
 *
 * @author sunx
 * @date 2022/1/4
 */
@Data
@ApiModel("询价dto")
public class SearchPriceDto {
  /** 价格类型编码 */
  @ApiModelProperty("价格类型编码")
  private String priceTypeCode;
  /** 价格绑定维度 */
  @ApiModelProperty("价格绑定维度,商品维度")
  private String dimensionCode;
  /** 价格绑定维度源数据编码集合 */
  @ApiModelProperty("价格绑定维度源数据编码集合，如商品编码集合")
  private Set<String> set;
  /** 询价时间 */
  @ApiModelProperty("询价时间,不传默认服务端当前时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date searchTime;
  /** 定价维度筛选项 */
  @ApiModelProperty("定价维度筛选项")
  private List<SearchPriceDimensionItemDto> dimensionItems;
}
