package com.biz.crm.mdm.business.price.sdk.service;

import com.biz.crm.mdm.business.price.sdk.dto.FindBusinessPriceDto;
import com.biz.crm.mdm.business.price.sdk.dto.FindPriceDto;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDto;
import com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo;
import com.google.common.collect.Maps;

import java.util.Map;

/**
 * 价格查询sdk接口
 *
 * @author sunx
 * @date 2022/1/4
 */
public interface PriceModelVoService {

  /**
   * 查询价格
   *
   * @param dto
   * @return
   */
  default Map<String, PriceModelVo> handleSearchPrice(SearchPriceDto dto) {
    return Maps.newHashMap();
  }

  /**
   * 询价，sdk建议使用该方法
   *
   * @param dto
   * @return
   */
  default Map<String, PriceModelVo> findPrice(FindPriceDto dto) {
    return Maps.newHashMap();
  }

  /**
   * 方式1询价，sdk建议使用该方法
   *
   * @param dto
   * @return
   */
  default Map<String, PriceModelVo> findBusinessPrice(FindBusinessPriceDto dto) {
    return Maps.newHashMap();
  }
}
