package com.biz.crm.mdm.business.price.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import lombok.Data;

/**
 * 价格维度基本信息vo
 *
 * @author sunx
 * @date 2021/12/30
 */
@Data
@ApiModel("价格维度基本信息vo")
public class PriceDimensionDictVo {

  /** 维度编码 */
  @ApiModelProperty("维度编码")
  private String code;
  /** 维度名称 */
  @ApiModelProperty("维度名称")
  private String name;
  /** 排序 */
  @ApiModelProperty("排序")
  private Integer sort;

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PriceDimensionDictVo that = (PriceDimensionDictVo) o;
    return Objects.equals(code, that.code);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code);
  }
}
