package com.biz.crm.mdm.business.price.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 价格类型主信息vo
 *
 * @author sunx
 * @date 2021-12-30 17:44:00
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "价格类型主信息Vo")
public class PriceTypeVo extends TenantFlagOpVo {
  /** 价格类型编码 */
  @ApiModelProperty("价格类型编码")
  private String typeCode;

  /** 价格类型名称 */
  @ApiModelProperty("价格类型名称")
  private String typeName;

  /** 价格维度集合 */
  @ApiModelProperty("价格维度集合")
  private List<PriceTypeDetailVo> detailList;
}
