package com.biz.crm.mdm.business.price.sdk.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.List;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 根据业务编码及商品维度询价dto
 *
 * @author sunx
 * @date 2022/6/14
 */
@Data
@ApiModel("根据业务编码及商品维度询价dto")
public class FindBusinessPriceDto {
  /** 价格类型编码 */
  @ApiModelProperty("价格类型编码，不设默认取配置文件crm.business.price.sale-price-code=sale_price")
  private String priceTypeCode;
  /**
   * 用户类型
   *
   * @see com.biz.crm.mdm.business.price.sdk.enums.FindPriceUserTypeEnum
   */
  @ApiModelProperty("用户类型")
  private String userType;
  /** 维度必须包含businessCode+productCode */
  @ApiModelProperty("询价维度信息")
  private List<FindBusinessPriceItemDto> list;
  /** 询价时间 */
  @ApiModelProperty("询价时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date searchTime;
}
