package com.biz.crm.mdm.business.price.sdk.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.Set;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 查询价格dto
 *
 * @author sunx
 * @date 2022/3/15
 */
@Data
@ApiModel("查询价格dto")
public class FindPriceDto {

  /**
   * 用户类型
   *
   * @see com.biz.crm.mdm.business.price.sdk.enums.FindPriceUserTypeEnum
   */
  @ApiModelProperty("用户类型")
  private String userType;

  /** 用户编码 */
  @ApiModelProperty("用户编码-经销商编码、终端编码")
  private String userCode;

  /**
   * 价格绑定维度 与productCodeSet对应
   *
   * @see com.biz.crm.mdm.business.price.sdk.enums.PriceDimensionEnum
   */
  @ApiModelProperty("价格绑定维度,不传默认是商品维度（product）")
  private String dimensionCode;

  /** 商品编码集合 */
  @ApiModelProperty("商品编码集合")
  private Set<String> productCodeSet;

  /** 价格类型编码 */
  @ApiModelProperty("价格类型编码，不设默认取配置文件crm.business.price.sale-price-code=sale_price")
  private Set<String> priceTypeCode;

  /** 询价时间 */
  @ApiModelProperty("询价时间,不传默认服务端当前时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date searchTime;
}
