package com.biz.crm.mdm.business.price.sdk.enums;

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 价格生效状态枚举
 *
 * @author sunx
 * @date 2022/1/4
 */
@Getter
@AllArgsConstructor
public enum EffectiveStatusEnum {
  /** 价格生效状态枚举 */
  DEFAULT("default", "default", "未生效", "0"),
  ACTIVE("active", "active", "生效中", "1"),
  OVERDUE("overdue", "overdue", "已过期", "2"),
  ;

  /** 系统key */
  private String key;
  /** 字典编码 */
  private String dictCode;
  /** 字典值 */
  private String value;
  /** 字典排序 */
  private String order;

  public static String getDesc(String code) {
    if (!StringUtils.isEmpty(code)) {
      EffectiveStatusEnum[] values = EffectiveStatusEnum.values();
      for (EffectiveStatusEnum value : values) {
        if (value.dictCode.equals(code)) {
          return value.value;
        }
      }
    }
    return null;
  }
}
