package com.biz.crm.mdm.business.price.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 价格维度类型枚举
 *
 * @author sunx
 * @date 2022/1/4
 */
@Getter
@AllArgsConstructor
public enum PriceDimensionEnum {
  /** 价格维度类型枚举 */
  CHANNEL("channel", "channel", "渠道", "0"),
  PRICE_GROUP("price_group", "price_group", "价格组", "1"),
  ORG("org", "org", "组织", "2"),
  PRODUCT("product", "product", "商品", "3"),
  CUSTOMER("customer", "customer", "客户", "4"),
  TERMINAL("terminal", "terminal", "终端", "5"),
  ;
  /** 系统key */
  private String key;
  /** 字典编码 */
  private String dictCode;
  /** 字典值 */
  private String value;
  /** 字典排序 */
  private String order;
}
