package com.biz.crm.mdm.business.price.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 价格设置维度配置明细vo
 *
 * @author sunx
 * @date 2021-12-30 17:43:59
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "价格设置维度配置明细Vo")
public class PriceDimensionVo extends TenantVo {
  /** 价格编码 */
  @ApiModelProperty("价格编码")
  private String priceCode;

  /** 价格类型编码 */
  @ApiModelProperty("价格类型编码")
  private String typeCode;

  /** 定价维度编码 */
  @ApiModelProperty("定价维度编码")
  private String typeDetailCode;

  /** 价格维度编码 */
  @ApiModelProperty("价格维度编码")
  private String dimensionCode;

  /** 维度数据源编码 */
  @ApiModelProperty("维度数据源编码")
  private String relateCode;

  /** 维度数据源名称（冗余） */
  @ApiModelProperty("维度数据源名称（冗余）")
  private String relateName;
}
