package com.biz.crm.mdm.business.price.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 价格类型维度信息vo
 *
 * @author sunx
 * @date 2021-12-30 17:44:01
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "价格类型维度信息Vo")
public class PriceTypeDetailVo extends TenantVo {
  /** 价格类型编码 */
  @ApiModelProperty("价格类型编码")
  private String typeCode;

  /** 定价维度编码 */
  @ApiModelProperty("定价维度编码")
  private String typeDetailCode;

  /** 定价维度名称 */
  @ApiModelProperty("定价维度名称")
  private String typeDetailName;

  /** 优先级 */
  @ApiModelProperty("优先级")
  private Integer sort;

  /** 价格维度配置明细 */
  @ApiModelProperty("价格维度配置明细")
  private List<PriceTypeDetailItemVo> itemList;
}
