package com.biz.crm.mdm.business.product.feign.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.product.feign.feign.ProductVoServiceFeign;
import com.biz.crm.mdm.business.product.sdk.dto.ProductDetailQueryDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductPaginationDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductQueryDto;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/**
 * 商品sdk实现
 *
 * @author sunx
 * @date 2021/11/16
 */
@Service
public class ProductVoServiceImpl implements ProductVoService {

  @Autowired(required = false)
  private ProductVoServiceFeign productVoServiceFeign;

  @Override
  public List<ProductVo> findDetailsByIdsOrProductCodes(
      List<String> ids, List<String> productCodes) {
    ids = Optional.ofNullable(ids).orElse(Lists.newLinkedList());
    productCodes = Optional.ofNullable(productCodes).orElse(Lists.newLinkedList());
    return this.productVoServiceFeign.findDetailsByIdsOrCodes(ids, productCodes).getResult();
  }

  @Override
  public ProductVo create(ProductDto dto) {
    throw new UnsupportedOperationException();
  }

  @Override
  public ProductVo update(ProductDto dto) {
    throw new UnsupportedOperationException();
  }

  @Override
  public List<ProductVo> findByProductLevelCodes(List<String> productLevelCodeList) {
    productLevelCodeList = Optional.ofNullable(productLevelCodeList).orElse(Lists.newLinkedList());
    return this.productVoServiceFeign.findByProductLevelCodes(productLevelCodeList).getResult();
  }

  @Override
  public List<ProductVo> findMainDetailsByProductCodes(List<String> productCodeList) {
    productCodeList = Optional.ofNullable(productCodeList).orElse(Lists.newLinkedList());
    return this.productVoServiceFeign.findMainDetailsByProductCodes(productCodeList).getResult();
  }

  @Override
  public List<ProductVo> findByProductQueryDto(ProductQueryDto dto) {
    return this.productVoServiceFeign.findByProductQueryDto(dto).getResult();
  }

  @Override
  public List<ProductVo> findDetailsByProductDetailQueryDto(ProductDetailQueryDto dto) {
    return this.productVoServiceFeign.findDetailsByProductDetailQueryDto(dto).getResult();
  }

  @Override
  public Map<String, String> findAllowSaleProductByProductLevelCodes(
      Set<String> productLevelCodes) {
    return this.productVoServiceFeign
        .findAllowSaleProductByProductLevelCodes(productLevelCodes)
        .getResult();
  }

  @Override
  public Page<ProductVo> findByConditions(Pageable pageable, ProductPaginationDto dto) {
    return this.productVoServiceFeign.findByConditions(pageable, dto).getResult();
  }
}
