package com.biz.crm.mdm.business.product.feign.feign;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.product.feign.feign.internal.ProductVoServiceFeignImpl;
import com.biz.crm.mdm.business.product.sdk.dto.DisplayProductDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductDetailQueryDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductPaginationDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductQueryDto;
import com.biz.crm.mdm.business.product.sdk.vo.DisplayProductVo;
import com.biz.crm.mdm.business.product.sdk.vo.ProductPlanningDetailsVo;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.product.feign.feign.internal.ProductVoServiceFeignImpl;
import com.biz.crm.mdm.business.product.sdk.dto.ProductDetailQueryDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductPaginationDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductQueryDto;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;

import io.swagger.annotations.ApiOperation;

/**
 * 商品feign
 *
 * @author sunx
 * @date 2021/11/16
 */
@FeignClient(
    name = "${mdm.feign-client.name:crm-mdm}",
    path = "crm-mdm",
    fallbackFactory = ProductVoServiceFeignImpl.class)
public interface ProductVoServiceFeign {

  /**
   * 根据商品商品id集合或编码集合获取商品信息
   *
   * @param ids
   * @param codes
   * @return
   */
  @GetMapping("/v1/product/product/findDetailsByIdsOrCodes")
  Result<List<ProductVo>> findDetailsByIdsOrCodes(
      @RequestParam("ids") List<String> ids, @RequestParam("codes") List<String> codes);

  /**
   * 根据商品层级获取对应的商品信息
   *
   * @param productLevelCodeList
   * @return
   */
  @GetMapping("/v1/product/product/findByProductLevelCodes")
  Result<List<ProductVo>> findByProductLevelCodes(
      @RequestParam("productLevelCodeList") List<String> productLevelCodeList);

  /**
   * 根据商品商品编码集合获取商品主信息+层级信息
   *
   * @param productCodeList
   * @return
   */
  @GetMapping(value = {"/v1/product/product/findMainDetailsByProductCodes"})
  Result<List<ProductVo>> findMainDetailsByProductCodes(
      @RequestParam("productCodeList") List<String> productCodeList);

  /**
   * 根据ProductQueryDto获取商品主信息
   *
   * @param dto
   * @return
   */
  @GetMapping(value = {"/v1/product/product/findByProductQueryDto"})
  Result<List<ProductVo>> findByProductQueryDto(@SpringQueryMap ProductQueryDto dto);

  /**
   * 根据ProductQueryDto获取商品主信息
   *
   * @param dto
   * @return
   */
  @PostMapping(value = {"/v1/product/product/findByQueryDto"})
  Result<List<ProductVo>> findByQueryDto(@RequestBody ProductQueryDto dto);

  /**
   * 根据ProductDetailQueryDto获取商品信息
   *
   * @param dto
   * @return
   */
  @GetMapping(value = {"/v1/product/product/findDetailsByProductDetailQueryDto"})
  Result<List<ProductVo>> findDetailsByProductDetailQueryDto(
      @SpringQueryMap ProductDetailQueryDto dto);

  /**
   * 根据层级获取层级及下级所有的上架且启用的产品集合
   *
   * @param productLevelCodes
   * @return
   */
  @GetMapping(value = {"/v1/product/product/findAllowSaleProductByProductLevelCodes"})
  Result<Map<String, String>> findAllowSaleProductByProductLevelCodes(
      @RequestParam("productLevelCodes") Set<String> productLevelCodes);

  /**
   * 查询分页列表
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  @ApiOperation(value = "查询分页列表")
  @GetMapping(value = {"/v1/product/product/findPageProductVoByConditions"})
  Result<Page<ProductVo>> findByConditions(
      @PageableDefault(50) Pageable pageable, @SpringQueryMap ProductPaginationDto paginationDto);

  /**
   * 条件查询
   * @author huojia
   * @date 2022/12/2 17:30
   * @param dto
   * @return java.util.List<com.biz.crm.mdm.business.product.sdk.vo.ProductVo>
   **/
  @ApiOperation(value = "条件查询")
  @PostMapping("/v1/product/product/queryCondition")
  Result<List<ProductVo>> queryCondition(@RequestBody ProductDto dto);

  /**
   * 根据商品编码集合获取商品集合
   *
   * @param productCodes
   * @return
   */
  @ApiOperation(value = "根据商品编码集合获取商品集合")
  @PostMapping("/v1/product/product/findByProductCodes")
  Result<List<ProductVo>> findByProductCodes(@RequestBody List<String> productCodes);

  /**
   * 根据商品编码集合获取对应的商品数据信息
   *
   * @param productCode
   * @param customerCode
   * @param businessModel
   * @param startDate
   * @return
   */
  @ApiOperation(value = "根据商品编码集合获取对应的商品数据")
  @GetMapping(value = {"/v1/productPlanningDetails/productPlanningDetails/findByProductPlanning"})
  Result<ProductPlanningDetailsVo> findByProductPlanningDetails(@RequestParam("productCode") String productCode, @RequestParam(name = "customerCode", required = false) String customerCode
          , @RequestParam(name = "businessModel", required = false) String businessModel, @RequestParam("startDate") String startDate);

  /**
   * 根据商品编码集合获取商品集合
   *
   * @return Result<List<String>>
   */
  @ApiOperation(value = "根据商品编码集合获取商品集合")
  @PostMapping(value = {"/v1/product/product/findAllProductCode"})
  Result<List<String>> findAllProductCode();


  /**
   * 根据商品编码集合获取商品集合
   *
   * @return Result<List<String>>
   */
  @ApiOperation(value = "根据商品编码集合获取商品集合")
  @PostMapping(value = {"/v1/product/product/findByCodes"})
  Result<List<ProductVo>> findByCodes(@RequestBody List<String> codes);

  /**
   * 根据商品编码集合获取商品集合
   *
   * @return Result<List < String>>
   */
  @ApiOperation(value = "根据商品编码集合获取商品集合")
  @PostMapping(value = {"/v1/product/product/getProductByCodes"})
  Result<Map<String, String>> getProductByCodes(@RequestBody List<List<String>> codes);

  /**
   * 根据商品商品id集合获取商品信息
   *
   * @param ids id列表
   * @return Result<List<ProductVo>>
   */
  @ApiOperation(value = "根据商品商品id集合或编码集合获取商品信息")
  @PostMapping(value = {"/v1/product/product/findDetailsByIds"})
  Result<List<ProductVo>> findDetailsByIds(@RequestBody List<String> ids);

  /**
   * 根据商品商品编码集合获取商品信息
   *
   * @param codes 编码列表
   * @return Result<List<ProductVo>>
   */
  @ApiOperation(value = "根据商品商品id集合或编码集合获取商品信息")
  @PostMapping(value = {"/v1/product/product/findDetailsByCodes"})
  Result<List<ProductVo>> findDetailsByCodes(@RequestBody List<String> codes);


  @ApiOperation(value = "根据业务type查询物料包或者品牌组或者品类名称")
  @PostMapping("/findPackageDescOrBrandOrgOrCategory")
  Result<List<DisplayProductVo>> findPackageDescOrBrandOrgOrCategory(@RequestBody DisplayProductDto displayProductDto);

}
