package com.biz.crm.mdm.business.product.feign.service.internal;

import com.biz.crm.mdm.business.product.sdk.vo.DisplayProductVo;
import com.biz.crm.mdm.business.product.sdk.dto.ProductDetailQueryDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductPaginationDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductQueryDto;
import com.biz.crm.mdm.business.product.sdk.dto.*;
import com.biz.crm.mdm.business.product.sdk.vo.ProductPlanningDetailsVo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.apache.http.util.Asserts;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.product.feign.feign.ProductVoServiceFeign;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

/**
 * 商品sdk实现
 *
 * @author sunx
 * @date 2021/11/16
 */
@Service
public class ProductVoServiceImpl implements ProductVoService {

    @Autowired(required = false)
    private ProductVoServiceFeign productVoServiceFeign;

    @Override
    public List<ProductVo> findDetailsByIdsOrProductCodes(List<String> ids, List<String> productCodes) {
        ids = Optional.ofNullable(ids).orElse(Lists.newLinkedList());
        productCodes = Optional.ofNullable(productCodes).orElse(Lists.newLinkedList());
        return this.productVoServiceFeign.findDetailsByIdsOrCodes(ids, productCodes).getResult();
    }

    @Override
    public List<ProductVo> findDetailsByIds(List<String> ids) {
        ids = Optional.ofNullable(ids).orElse(Lists.newLinkedList());
        return this.productVoServiceFeign.findDetailsByIds(ids).getResult();
    }

    @Override
    public List<ProductVo> findDetailsByProductCodes(List<String> productCodes) {
        productCodes = Optional.ofNullable(productCodes).orElse(Lists.newLinkedList());
        return this.productVoServiceFeign.findDetailsByCodes(productCodes).getResult();
    }

    @Override
    public List<ProductVo> findByCodes(List<String> codes) {
        Result<List<ProductVo>> result = this.productVoServiceFeign.findByCodes(codes);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    @Override
    public ProductVo create(ProductDto dto) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ProductVo update(ProductDto dto) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ProductVo> findByProductLevelCodes(List<String> productLevelCodeList) {
        productLevelCodeList = Optional.ofNullable(productLevelCodeList).orElse(Lists.newLinkedList());
        return this.productVoServiceFeign.findByProductLevelCodes(productLevelCodeList).getResult();
    }

    @Override
    public List<ProductVo> findMainDetailsByProductCodes(List<String> productCodeList) {
        productCodeList = Optional.ofNullable(productCodeList).orElse(Lists.newLinkedList());
        return this.productVoServiceFeign.findMainDetailsByProductCodes(productCodeList).getResult();
    }

    @Override
    public List<ProductVo> findByProductQueryDto(ProductQueryDto dto) {
        return this.productVoServiceFeign.findByProductQueryDto(dto).getResult();
    }

    @Override
    public List<ProductVo> findByQueryDto(ProductQueryDto dto) {
        return this.productVoServiceFeign.findByQueryDto(dto).getResult();
    }

    @Override
    public List<ProductVo> findDetailsByProductDetailQueryDto(ProductDetailQueryDto dto) {
        return this.productVoServiceFeign.findDetailsByProductDetailQueryDto(dto).getResult();
    }

    @Override
    public Map<String, String> findAllowSaleProductByProductLevelCodes(Set<String> productLevelCodes) {
        return this.productVoServiceFeign.findAllowSaleProductByProductLevelCodes(productLevelCodes).getResult();
    }

    @Override
    public Page<ProductVo> findByConditions(Pageable pageable, ProductPaginationDto dto) {
        return this.productVoServiceFeign.findByConditions(pageable, dto).getResult();
    }

    @Override
    public List<ProductVo> queryCondition(ProductDto dto) {
        Result<List<ProductVo>> listResult = this.productVoServiceFeign.queryCondition(dto);
        Validate.isTrue(listResult.isSuccess(), listResult.getMessage());
        return listResult.getResult();
    }

    @Override
    public ProductVo finByUnitTypeCode(String unitTypeCode) {
        return null;
    }

    @Override
    public ProductPlanningDetailsVo findByProductPlanningDetails(String productCode, String customerCode, String businessModel, String startDate) {
        Result<ProductPlanningDetailsVo> result = productVoServiceFeign.findByProductPlanningDetails(productCode, customerCode, businessModel, startDate);
        Validate.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    /**
     * 根据商品编码集合获取商品集合
     *
     * @return List<String>
     */
    @Override
    public List<String> findAllProductCode() {
        Result<List<String>> result = productVoServiceFeign.findAllProductCode();
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    @Override
    public Map<String, String> getProductByCodes(List<List<String>> codes) {
        Result<Map<String, String>> result = productVoServiceFeign.getProductByCodes(codes);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    @Override
    public ProductVo updateSynchronous(ProductSynchronousUpdateDto dto) {
        return null;
    }

    @Override
    public List<DisplayProductVo> findPackageDescOrBrandOrgOrCategory(
        DisplayProductDto displayProductDto) {
        Result<List<DisplayProductVo>> result = productVoServiceFeign.findPackageDescOrBrandOrgOrCategory(
            displayProductDto);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

  @Override
  public Boolean validProductGroupUnion(List<ProductCodeUnitGroup> productCodeUnitGroups,
                                        List<ProductLevelUnitsGroup> productLevelUnitsGroups) {
    return false;
  }


  @Override
    public List<ProductVo> findByProductCodes(List<String> productCodes) {
        productCodes = Optional.ofNullable(productCodes).orElse(Lists.newLinkedList());
        return this.productVoServiceFeign.findByProductCodes(productCodes).getResult();
    }

}
