package com.biz.crm.mdm.business.product.feign.feign.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.product.feign.feign.ProductVoServiceFeign;
import com.biz.crm.mdm.business.product.sdk.dto.ProductDetailQueryDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductPaginationDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductQueryDto;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import org.springframework.cloud.openfeign.FallbackFactory;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 商品feign熔断实现
 *
 * @author sunx
 * @date 2021/11/16
 */
@Component
public class ProductVoServiceFeignImpl implements FallbackFactory<ProductVoServiceFeign> {

  @Override
  public ProductVoServiceFeign create(Throwable throwable) {
    return new ProductVoServiceFeign() {
      @Override
      public Result<List<ProductVo>> findDetailsByIdsOrCodes(List<String> ids, List<String> codes) {
        throw new UnsupportedOperationException("根据商品商品id集合或编码集合获取商品信息熔断");
      }

      @Override
      public Result<List<ProductVo>> findByProductLevelCodes(List<String> productLevelCodeList) {
        throw new UnsupportedOperationException("根据商品层级获取对应的商品信息熔断");
      }

      @Override
      public Result<List<ProductVo>> findMainDetailsByProductCodes(List<String> productCodeList) {
        throw new UnsupportedOperationException("根据商品商品编码集合获取商品主信息+层级信息熔断");
      }

      @Override
      public Result<List<ProductVo>> findByProductQueryDto(ProductQueryDto dto) {
        throw new UnsupportedOperationException("根据ProductQueryDto获取商品主信息熔断");
      }

      @Override
      public Result<List<ProductVo>> findByQueryDto(ProductQueryDto dto) {
        throw new UnsupportedOperationException("根据ProductQueryDto获取商品主信息熔断");
      }

      @Override
      public Result<List<ProductVo>> findDetailsByProductDetailQueryDto(ProductDetailQueryDto dto) {
        throw new UnsupportedOperationException("根据ProductDetailQueryDto获取商品信息熔断");
      }

      @Override
      public Result<Map<String, String>> findAllowSaleProductByProductLevelCodes(
          Set<String> productLevelCodes) {
        throw new UnsupportedOperationException("根据层级获取层级及下级所有的上架且启用的产品集合熔断");
      }

      @Override
      public Result<Page<ProductVo>> findByConditions(Pageable pageable, ProductPaginationDto paginationDto) {
        throw new UnsupportedOperationException("查询分页列表熔断");
      }
    };
  }
}
