package com.biz.crm.mdm.business.product.level.feign.service.internal;

import com.biz.crm.mdm.business.product.level.feign.feign.ProductLevelVoSdkServiceFeign;
import com.biz.crm.mdm.business.product.level.sdk.dto.RelateProductLevelCodeQueryDto;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 商品层级sdk实现
 *
 * @author sunx
 * @date 2021/11/16
 */
@Service
public class ProductLevelVoSdkServiceImpl implements ProductLevelVoSdkService {

  @Autowired(required = false) private ProductLevelVoSdkServiceFeign productLevelVoSdkServiceFeign;

  @Override
  public ProductLevelVo findDetailsById(String id) {
    throw new UnsupportedOperationException();
  }

  @Override
  public List<ProductLevelVo> findListByIds(List<String> ids) {
    throw new UnsupportedOperationException();
  }

  @Override
  public ProductLevelVo findDetailsByCode(String code) {
    throw new UnsupportedOperationException();
  }

  @Override
  public List<ProductLevelVo> findListByCodes(List<String> codes) {
    return productLevelVoSdkServiceFeign.findListByCodes(codes).getResult();
  }

  @Override
  public List<String> findCurAndChildrenCodesByCodes(Set<String> productLevelCodeSet) {
    return productLevelVoSdkServiceFeign.findCurAndChildrenCodesByCodes(productLevelCodeSet).getResult();
  }

  @Override
  public Map<String, List<ProductLevelVo>> findCurAndParentByCodes(List<String> codes) {
    return productLevelVoSdkServiceFeign.findCurAndParentByCodes(codes).getResult();
  }

  @Override
  public Map<String, String> findByRelateProductLevelCodeQueryDto(
      RelateProductLevelCodeQueryDto dto) {
    return productLevelVoSdkServiceFeign.findByRelateProductLevelCodeQueryDto(dto).getResult();
  }
}
