package com.biz.crm.mdm.business.product.level.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.product.level.feign.feign.internal.ProductLevelVoSdkServiceFeignImpl;
import com.biz.crm.mdm.business.product.level.sdk.dto.RelateProductLevelCodeQueryDto;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 商品层级feign
 *
 * @author sunx
 * @date 2021/11/16
 */
@FeignClient(
    name = "${mdm.feign-client.name:crm-mdm}",
    path = "crm-mdm",
    fallbackFactory = ProductLevelVoSdkServiceFeignImpl.class)
public interface ProductLevelVoSdkServiceFeign {

  /**
   * 根据层级编码获取商品层级明细信息
   *
   * @param productLevelCode
   * @return
   */
  @GetMapping("/v1/productLevel/productLevel/findAllParentsByProductLevelCode")
  Result<List<ProductLevelVo>> findAllParentsByProductLevelCode(@RequestParam("productLevelCode") String productLevelCode);

  /**
   * 根据层级编码获取商品层级明细信息
   *
   * @param codes
   * @return
   */
  @GetMapping("/v1/productLevel/productLevel/findListByCodes")
  Result<List<ProductLevelVo>> findListByCodes(@RequestParam("codes") List<String> codes);

  /**
   * 根据产品层级编码查询该产品层级及全部下级层级的编码
   *
   * @param productLevelCodes
   * @return
   */
  @GetMapping("/v1/productLevel/productLevel/findCurAndChildrenCodesByCodes")
  Result<List<String>> findCurAndChildrenCodesByCodes(@RequestParam("codes") Set<String> productLevelCodes);

  /**
   * 通过产品层级编码集合获取当前编码对应的产品层级以及其上级产品层级
   *
   * @param codes 产品层级编码
   * @return 产品层级映射(key_产品层级编码, value_当前编码对应的产品层级以及其上级产品层级列表)
   */
  @GetMapping("/v1/productLevel/productLevel/findCurAndParentByCodes")
  Result<Map<String, List<ProductLevelVo>>> findCurAndParentByCodes(@RequestParam("codes")List<String> codes);

  /**
   * 获取产品层级对应的未删除的上级或下级编码
   *
   * @param dto
   * @return
   */
  @GetMapping("/v1/productLevel/productLevel/findByRelateProductLevelCodeQueryDto")
  Result<Map<String, String>> findByRelateProductLevelCodeQueryDto(@SpringQueryMap RelateProductLevelCodeQueryDto dto);
}
