package com.biz.crm.mdm.business.product.level.feign.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.product.level.feign.feign.ProductLevelVoSdkServiceFeign;
import com.biz.crm.mdm.business.product.level.sdk.dto.RelateProductLevelCodeQueryDto;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 商品层级feign熔断实现
 *
 * @author sunx
 * @date 2021/11/16
 */
@Component
public class ProductLevelVoSdkServiceFeignImpl
    implements FallbackFactory<ProductLevelVoSdkServiceFeign> {

  @Override
  public ProductLevelVoSdkServiceFeign create(Throwable throwable) {
    return new ProductLevelVoSdkServiceFeign() {

      @Override
      public Result<List<ProductLevelVo>> findAllParentsByProductLevelCode(String productLevelCode) {
        throw new UnsupportedOperationException("按照编码查询所有的父节点信息熔断");
      }

      @Override
      public Result<List<ProductLevelVo>> findListByCodes(List<String> codes) {
        throw new UnsupportedOperationException("根据层级编码获取商品层级明细信息熔断");
      }

      @Override
      public Result<List<String>> findCurAndChildrenCodesByCodes(Set<String> productLevelCodes) {
        throw new UnsupportedOperationException("据产品层级编码查询该产品层级及全部下级层级的编码熔断");
      }

      @Override
      public Result<Map<String, List<ProductLevelVo>>> findCurAndParentByCodes(List<String> codes) {
        throw new UnsupportedOperationException("根据层级编码获取当前层级及上级明细信息熔断");
      }

      @Override
      public Result<Map<String, String>> findByRelateProductLevelCodeQueryDto(
          RelateProductLevelCodeQueryDto dto) {
        throw new UnsupportedOperationException("获取产品层级对应的未删除的上级或下级编码熔断");
      }
    };
  }
}
