package com.biz.crm.mdm.business.product.level.local.authority;

import com.biz.crm.mdm.business.product.level.local.service.ProductLevelVoService;
import com.bizunited.nebula.mars.sdk.register.SelectAuthorityModeRegister;
import com.bizunited.nebula.security.sdk.vo.LoginDetails;
import com.google.common.collect.Sets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import java.util.Arrays;
import java.util.List;
import java.util.Set;

/**
 * @Author: heguanyun
 * @Date: 2022/4/8 10:31 description:
 */
@Lazy
@Component("productLevelSelectAuthorityModeRegister")
public class ProductLevelAuthorityModeRegister implements SelectAuthorityModeRegister {
  @Autowired(required = false)
  private ApplicationContext applicationContext;

  @Override
  public String modeKey() {
    return "productLevelAuthorityModeRegister";
  }

  @Override
  public String modeName() {
    return "查询制定产品层级下的数据";
  }

  @Override
  public String controlKey() {
    return "productLevelAuthorityModeRegister_select";
  }

  @Override
  public int sort() {
    return 6;
  }

  @Override
  public String groupCode() {
    return "product_level_group";
  }

  @Override
  public boolean isArrayValue() {
    return true;
  }

  @Override
  public boolean isStaticValue() {
    return true;
  }

  @Override
  public Class<?> modeValueClass() {
    return String.class;
  }

  @Override
  public Object staticValue(String[] staticValues) {
    if (staticValues == null || staticValues.length == 0) {
      return null;
    }
    ProductLevelVoService productLevelVoService = applicationContext.getBean(ProductLevelVoService.class);
    Set<String> codeSet = Sets.newHashSet(Arrays.asList(staticValues));
    List<String> codes = productLevelVoService.findCurAndChildrenCodesByCodes(codeSet);
    return codes.stream().distinct().toArray(String[]::new);
  }

  @Override
  public Object dynamicValue(LoginDetails loginDetails, String modeGroupCode) {
    return null;
  }

  @Override
  public String converterKey() {
    return "chartArrayMarsAuthorityAstConverter";
  }
}
