package com.biz.crm.mdm.business.product.level.local.notifier;
/**
 * Created by Bao Hongbin on 2021-10-12 17:15.
 */

import com.biz.crm.mdm.business.product.level.sdk.event.ProductLevelEventListener;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.bizunited.nebula.common.util.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @program: crm
 * @description: TODO 推送作日志（目前尚无记录日志功能，该功能将在后续改造中实现，目前无法实现推送，暂时记录为info级系统日志）
 * @author: Bao Hongbin
 * @create: 2021-10-12 17:15
 **/
@Component
@Slf4j
public class ProductLevelEventLogListenerImpl implements ProductLevelEventListener {
  /**
   * 新增产品层级记录日志
   *
   * @param productLevelVos
   */
  @Override
  public void onBatchCreate(List<ProductLevelVo> productLevelVos) {
    log.info("新增产品层级信息：{}", JsonUtils.obj2JsonString(productLevelVos));
  }

  /**
   * 更新产品层级记录日志
   *
   * @param productLevelVos
   */
  @Override
  public void onBatchUpdate(List<ProductLevelVo> productLevelVos) {
    log.info("更新产品层级信息：{}", JsonUtils.obj2JsonString(productLevelVos));
  }

  /**
   * 删除产品层级记录日志
   *
   * @param productLevelVos
   */
  @Override
  public void onBatchDelete(List<ProductLevelVo> productLevelVos) {
    log.info("删除产品层级信息：{}", JsonUtils.obj2JsonString(productLevelVos));
  }

  /**
   * 启用产品层级记录日志
   *
   * @param productLevelVos
   */
  @Override
  public void onBatchEnable(List<ProductLevelVo> productLevelVos) {
    log.info("启用产品层级信息：{}", JsonUtils.obj2JsonString(productLevelVos));
  }

  /**
   * 禁用产品层级记录日志
   *
   * @param productLevelVos
   */
  @Override
  public void onBatchDisable(List<ProductLevelVo> productLevelVos) {
    log.info("禁用产品层级信息：{}", JsonUtils.obj2JsonString(productLevelVos));
  }
}
