/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.product.level.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.TenantFlagTreeOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.dto.TreeDto;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.vo.LazyTreeVo;
import com.biz.crm.mdm.business.product.level.local.entity.ProductLevel;
import com.biz.crm.mdm.business.product.level.local.mapper.ProductLevelMapper;
import com.biz.crm.mdm.business.product.level.sdk.dto.ProductLevelPaginationDto;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ProductLevelRepository
extends ServiceImpl<ProductLevelMapper, ProductLevel> {
    public Page<ProductLevelVo> findByConditions(Pageable pageable, ProductLevelPaginationDto productLevelPaginationDto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return ((ProductLevelMapper)this.baseMapper).findByConditions((Page<ProductLevelVo>)page, productLevelPaginationDto, DelFlagStatusEnum.NORMAL);
    }

    public ProductLevel findDetailsById(String id, String tenantCode) {
        return (ProductLevel)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(UuidEntity::getId, (Object)id)).one());
    }

    public ProductLevel findDetailsByCode(String code, String tenantCode) {
        return (ProductLevel)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(ProductLevel::getProductLevelCode, (Object)code)).one());
    }

    public List<ProductLevel> findDetailsByCodes(Set<String> codeSet, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(ProductLevel::getProductLevelCode, codeSet)).list();
    }

    public List<ProductLevel> findListByCode(String code, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(ProductLevel::getProductLevelCode, (Object)code)).list();
    }

    public List<ProductLevel> findChildrenListByParentCode(String parentCode, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).isNull(!StringUtils.isNotEmpty((CharSequence)parentCode), ProductLevel::getParentCode)).eq(StringUtils.isNotEmpty((CharSequence)parentCode), ProductLevel::getParentCode, (Object)parentCode)).list();
    }

    public List<ProductLevel> findListByIds(List<String> ids, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, ids)).list();
    }

    public List<ProductLevel> findListByRuleCodes(Set<String> ruleCodes, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(TenantFlagTreeOpEntity::getRuleCode, ruleCodes)).list();
    }

    public List<ProductLevel> findCurAndChildrenByRuleCodeList(List<String> ruleCodes, String enableStatus, String tenantCode) {
        return ((ProductLevelMapper)this.baseMapper).findCurAndChildrenByRuleCodeList(ruleCodes, enableStatus, tenantCode, DelFlagStatusEnum.NORMAL);
    }

    public List<ProductLevel> findChildrenListByParentCodes(List<String> parentCodes, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(ProductLevel::getParentCode, parentCodes)).list();
    }

    public void updateOrphanParentCodeNull(String tenantCode) {
        ((ProductLevelMapper)this.baseMapper).updateOrphanParentCodeNull(tenantCode, DelFlagStatusEnum.NORMAL);
    }

    public List<ProductLevel> findListWithoutParentCode(String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).isNull(ProductLevel::getParentCode)).list();
    }

    public List<ProductLevel> findListByCodes(List<String> codes, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(ProductLevel::getProductLevelCode, codes)).list();
    }

    public List<ProductLevel> findCurAndChildrenByRuleCode(String ruleCode, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).likeRight(TenantFlagTreeOpEntity::getRuleCode, (Object)ruleCode)).list();
    }

    public List<ProductLevel> findAll(String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public List<ProductLevel> findListLikeName(String enableStatus, String name, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(StringUtils.isNotEmpty((CharSequence)enableStatus), UuidFlagOpEntity::getEnableStatus, (Object)enableStatus)).like(StringUtils.isNotEmpty((CharSequence)name), ProductLevel::getProductLevelName, (Object)name)).list();
    }

    public List<ProductLevel> findListLikeName(TreeDto dto) {
        dto = Optional.ofNullable(dto).orElse(new TreeDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        return ((ProductLevelMapper)this.baseMapper).findListLikeName(dto);
    }

    public List<LazyTreeVo> findLazyTreeList(String enableStatus, Boolean topOnly, String parentCode, List<String> codeList, List<String> ruleCodeList, String excludeRuleCode, String tenantCode) {
        return ((ProductLevelMapper)this.baseMapper).findLazyTreeList(enableStatus, topOnly, parentCode, codeList, ruleCodeList, excludeRuleCode, tenantCode, DelFlagStatusEnum.NORMAL);
    }

    public void setParentCodeNull(String id) {
        ((ProductLevelMapper)this.baseMapper).setParentCodeNull(id);
    }

    public void setParentCodeAndRuleCodeNull(String id) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(ProductLevel::getParentCode, null)).set(TenantFlagTreeOpEntity::getRuleCode, (Object)"")).eq(UuidEntity::getId, (Object)id)).update();
    }

    public List<ProductLevel> findByProductLevelType(String productLevelType, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(ProductLevel::getProductLevelType, (Object)productLevelType)).list();
    }

    public List<String> findCodeByCurAndChildrenByRuleCodes(Set<String> ruleCodeSet, String tenantCode) {
        if (CollectionUtils.isEmpty(ruleCodeSet)) {
            return Lists.newLinkedList();
        }
        return ((ProductLevelMapper)this.baseMapper).findCodeByCurAndChildrenByRuleCodes(ruleCodeSet, tenantCode, DelFlagStatusEnum.NORMAL.getCode());
    }
}

