/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.product.level.local.service.helper;

import com.biz.crm.mdm.business.product.level.local.entity.ProductLevel;
import com.biz.crm.mdm.business.product.level.local.repository.ProductLevelRepository;
import com.biz.crm.mdm.business.product.level.sdk.dto.ProductLevelCreateDto;
import com.biz.crm.mdm.business.product.level.sdk.dto.ProductLevelUpdateDto;
import com.biz.crm.mdm.business.product.level.sdk.event.ProductLevelEventListener;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ProductLevelServiceHelper {
    private static final Logger log = LoggerFactory.getLogger(ProductLevelServiceHelper.class);
    @Autowired(required=false)
    private List<ProductLevelEventListener> productLevelEventListeners;
    @Autowired(required=false)
    private ProductLevelRepository productLevelRepository;

    public void createValidation(ProductLevelCreateDto productLevelCreateDto) {
        Validate.notNull((Object)productLevelCreateDto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        log.info("\u65b0\u589e\u4ea7\u54c1\u5c42\u7ea7\u8bf7\u6c42dto\uff1a{}", (Object)JsonUtils.obj2JsonString((Object)productLevelCreateDto));
        if (StringUtils.isNotEmpty((CharSequence)productLevelCreateDto.getProductLevelCode())) {
            List<ProductLevel> productLevels = this.productLevelRepository.findListByCode(productLevelCreateDto.getProductLevelCode(), TenantUtils.getTenantCode());
            Validate.isTrue((boolean)CollectionUtils.isEmpty(productLevels), (String)("\u7f16\u7801[" + productLevelCreateDto.getProductLevelCode() + "]\u5df2\u5b58\u5728"), (Object[])new Object[0]);
        }
        if (StringUtils.isNotEmpty((CharSequence)productLevelCreateDto.getParentCode())) {
            ProductLevel parent = this.productLevelRepository.findDetailsByCode(productLevelCreateDto.getParentCode(), TenantUtils.getTenantCode());
            Validate.notNull((Object)((Object)parent), (String)"\u4e0a\u7ea7\u7f16\u7801\u65e0\u6548", (Object[])new Object[0]);
        }
        Validate.notBlank((CharSequence)productLevelCreateDto.getProductLevelName(), (String)"\u65b0\u589e\u4fe1\u606f\u65f6\uff0c\u4ea7\u54c1\u5c42\u7ea7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)productLevelCreateDto.getProductLevelType(), (String)"\u65b0\u589e\u4fe1\u606f\u65f6\uff0c\u4ea7\u54c1\u5c42\u7ea7\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((productLevelCreateDto.getProductLevelName().length() < 64 ? 1 : 0) != 0, (String)"\u4ea7\u54c1\u5c42\u7ea7\u540d\u79f0\u4fe1\u606f\uff0c\u5728\u8fdb\u884c\u65b0\u589e\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    public void sendCreateEvent(List<ProductLevelVo> productLevelVos) {
        if (Objects.nonNull(this.productLevelEventListeners)) {
            for (ProductLevelEventListener listener : this.productLevelEventListeners) {
                listener.onBatchCreate(productLevelVos);
            }
        }
    }

    public void updateValidation(ProductLevelUpdateDto productLevelUpdateDto) {
        Validate.notNull((Object)productLevelUpdateDto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        log.info("\u7f16\u8f91\u4ea7\u54c1\u5c42\u7ea7\u8bf7\u6c42dto\uff1a{}", (Object)JsonUtils.obj2JsonString((Object)productLevelUpdateDto));
        Validate.notBlank((CharSequence)productLevelUpdateDto.getId(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u4ea7\u54c1\u5c42\u7ea7ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ProductLevel productLevel = this.productLevelRepository.findDetailsById(productLevelUpdateDto.getId(), TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)productLevel), (String)"\u65e0\u6548\u7684\u4e1a\u52a1\u6280\u672f\u7f16\u53f7\u4fe1\u606f", (Object[])new Object[0]);
        Validate.isTrue((boolean)productLevel.getProductLevelCode().equals(productLevelUpdateDto.getProductLevelCode()), (String)"\u4ea7\u54c1\u5c42\u7ea7\u7f16\u7801\u4e0d\u80fd\u4fee\u6539", (Object[])new Object[0]);
        if (StringUtils.isNotEmpty((CharSequence)productLevelUpdateDto.getParentCode())) {
            ProductLevel parent = this.productLevelRepository.findDetailsByCode(productLevelUpdateDto.getParentCode(), TenantUtils.getTenantCode());
            Validate.notNull((Object)((Object)parent), (String)"\u4e0a\u7ea7\u4ea7\u54c1\u5c42\u7ea7\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            Validate.isTrue((!parent.getId().equals(productLevel.getId()) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u4ea7\u54c1\u5c42\u7ea7\u4e0d\u80fd\u662f\u81ea\u5df1", (Object[])new Object[0]);
            Validate.isTrue((!parent.getRuleCode().startsWith(productLevel.getRuleCode()) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u4ea7\u54c1\u5c42\u7ea7\u4e0d\u80fd\u662f\u5f53\u524d\u5c42\u7ea7\u7684\u4e0b\u7ea7", (Object[])new Object[0]);
        }
        Validate.notBlank((CharSequence)productLevelUpdateDto.getProductLevelName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u4ea7\u54c1\u5c42\u7ea7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)productLevelUpdateDto.getProductLevelType(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u4ea7\u54c1\u5c42\u7ea7\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((productLevelUpdateDto.getProductLevelName().length() < 64 ? 1 : 0) != 0, (String)"\u4ea7\u54c1\u5c42\u7ea7\u540d\u79f0\u4fe1\u606f\uff0c\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    public void sendUpdateEvent(List<ProductLevelVo> productLevelVos) {
        if (Objects.nonNull(this.productLevelEventListeners)) {
            for (ProductLevelEventListener listener : this.productLevelEventListeners) {
                listener.onBatchUpdate(productLevelVos);
            }
        }
    }

    public void sendDeleteEvent(List<ProductLevelVo> productLevelVos) {
        if (Objects.nonNull(this.productLevelEventListeners)) {
            for (ProductLevelEventListener listener : this.productLevelEventListeners) {
                listener.onBatchDelete(productLevelVos);
            }
        }
    }

    public void sendEnableEvent(List<ProductLevelVo> productLevelVos) {
        if (Objects.nonNull(this.productLevelEventListeners)) {
            for (ProductLevelEventListener listener : this.productLevelEventListeners) {
                listener.onBatchEnable(productLevelVos);
            }
        }
    }

    public void sendDisableEvent(List<ProductLevelVo> productLevelVos) {
        if (Objects.nonNull(this.productLevelEventListeners)) {
            for (ProductLevelEventListener listener : this.productLevelEventListeners) {
                listener.onBatchDisable(productLevelVos);
            }
        }
    }
}

