/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.product.level.local.service.internal;

import com.biz.crm.business.common.local.entity.TenantFlagTreeOpEntity;
import com.biz.crm.business.common.sdk.dto.TreeDto;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategy;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategyHolder;
import com.biz.crm.business.common.sdk.utils.TreeUtil;
import com.biz.crm.business.common.sdk.vo.LazyTreeVo;
import com.biz.crm.mdm.business.product.level.local.entity.ProductLevel;
import com.biz.crm.mdm.business.product.level.local.repository.ProductLevelRepository;
import com.biz.crm.mdm.business.product.level.local.service.ProductLevelLazyTreeVoService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ProductLevelLazyTreeVoServiceImpl
implements ProductLevelLazyTreeVoService {
    @Autowired(required=false)
    private ProductLevelRepository productLevelRepository;
    @Autowired(required=false)
    private TreeRuleCodeStrategyHolder treeRuleCodeStrategyHolder;

    @Override
    public List<LazyTreeVo> findLazyTree(TreeDto treeDto) {
        ProductLevel one;
        treeDto = Optional.ofNullable(treeDto).orElse(new TreeDto());
        ArrayList<LazyTreeVo> list = new ArrayList<LazyTreeVo>();
        String excludeRuleCode = "";
        if (StringUtils.isNotEmpty((CharSequence)treeDto.getExcludeCodeAndChildren()) && (one = this.productLevelRepository.findDetailsByCode(treeDto.getExcludeCodeAndChildren(), TenantUtils.getTenantCode())) != null) {
            excludeRuleCode = one.getRuleCode();
        }
        if (StringUtils.isNotEmpty((CharSequence)treeDto.getParentCode())) {
            list.addAll(this.productLevelRepository.findLazyTreeList(treeDto.getEnableStatus(), null, treeDto.getParentCode(), null, null, excludeRuleCode, TenantUtils.getTenantCode()));
        } else if (!StringUtils.isEmpty((CharSequence)treeDto.getName())) {
            List<ProductLevel> likeList = this.productLevelRepository.findListLikeName(treeDto.getEnableStatus(), treeDto.getName(), TenantUtils.getTenantCode());
            if (!CollectionUtils.isEmpty(likeList)) {
                TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
                Set parentRuleCodes = treeRuleCodeStrategy.findParentRuleCodeByRuleCodes(3, likeList.stream().map(TenantFlagTreeOpEntity::getRuleCode).collect(Collectors.toList()));
                list.addAll(this.productLevelRepository.findLazyTreeList(treeDto.getEnableStatus(), null, null, null, new ArrayList<String>(parentRuleCodes), excludeRuleCode, TenantUtils.getTenantCode()));
            }
        } else {
            list.addAll(this.productLevelRepository.findLazyTreeList(treeDto.getEnableStatus(), true, null, null, null, excludeRuleCode, TenantUtils.getTenantCode()));
        }
        if (!CollectionUtils.isEmpty(list)) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                LazyTreeVo lazyTreeVo;
                lazyTreeVo.setHasChild(Boolean.valueOf(null != (lazyTreeVo = (LazyTreeVo)iterator.next()).getHasChildFlag() && lazyTreeVo.getHasChildFlag().compareTo(0) > 0));
            }
            return TreeUtil.generateLazyTreeByParentCode(list);
        }
        return new ArrayList<LazyTreeVo>();
    }
}

