package com.biz.crm.mdm.business.product.level.local.authority;

import com.bizunited.nebula.mars.sdk.register.SelectAuthorityModeGroupRegister;
import com.google.common.collect.Sets;
import org.springframework.stereotype.Component;

import java.util.Set;

/**
 * @Author: heguanyun
 * @Date: 2022/4/8 10:24
 * description:根据产品层级筛选数据
 */
@Component("productLevelAuthorityModeGroupRegister")
public class ProductLevelAuthorityModeGroupRegister implements SelectAuthorityModeGroupRegister {

  @Override
  public String groupCode() {
    return "product_level_group";
  }

  @Override
  public String groupName() {
    return "按照产品层级维度授权";
  }

  @Override
  public Set<String> viewFieldNames() {
    return Sets.newHashSet("productLevelCode");
  }

  @Override
  public Set<String> repositoryFieldNames() {
    return Sets.newHashSet("product_level_code");
  }
}
