package com.biz.crm.mdm.business.product.level.local.deprecated.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.biz.crm.business.common.sdk.deprecated.model.PageResult;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mdm.business.product.level.local.service.ProductLevelVoService;
import com.biz.crm.mdm.business.product.level.sdk.deprecated.dto.MdmProductLevelDto;
import com.biz.crm.mdm.business.product.level.sdk.deprecated.dto.MdmProductLevelSelectDto;
import com.biz.crm.mdm.business.product.level.sdk.deprecated.vo.MdmProductLevelSelectVo;
import com.biz.crm.mdm.business.product.level.sdk.deprecated.vo.MdmProductLevelVo;
import com.biz.crm.mdm.business.product.level.sdk.dto.ProductLevelCreateDto;
import com.biz.crm.mdm.business.product.level.sdk.dto.ProductLevelPaginationDto;
import com.biz.crm.mdm.business.product.level.sdk.dto.ProductLevelUpdateDto;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Sets;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 产品层级
 *
 * @author Liao.Hua
 * @date 2020-09-01 14:13:56
 */
@Slf4j
@RestController
@RequestMapping("/mdmProductLevelController")
@Api(tags = "MDM-产品层级")
/*@CrmGlobalLog*/
@Deprecated
public class MdmProductLevelController {

  private final Integer SELECT_BOX_OPTION_SIZE = 50;
  private final String MDM_PRODUCT_LEVEL_LOCK_HASH = "MDM_PRODUCT_LEVEL_LOCK_HASH_0112:";
  private final String MDM_PRODUCT_LEVEL_PARENT_HASH = "MDM_PRODUCT_LEVEL_PARENT_HASH_0112:";
  private final String MDM_PRODUCT_LEVEL_CHILDREN_HASH = "MDM_PRODUCT_LEVEL_CHILDREN_HASH_0112:";
  private final String MDM_PRODUCT_LEVEL_SELF_HASH = "MDM_PRODUCT_LEVEL_SELF_HASH_0112:";


  @Autowired(required = false)
  private ProductLevelVoService mdmProductLevelVoService;
  @Autowired(required = false)
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private RedisService redisService;

  @ApiOperation(value = "查询列表(分页)")
  @PostMapping("/pageList")
  @Deprecated
  public Result<PageResult<MdmProductLevelVo>> pageList(@RequestBody MdmProductLevelDto mdmProductLevelReqVo) {
    try {
      mdmProductLevelReqVo = ObjectUtils.defaultIfNull(mdmProductLevelReqVo, new MdmProductLevelDto());
      Pageable pageable = PageRequest.of(mdmProductLevelReqVo.getPageNum(), mdmProductLevelReqVo.getPageSize());
      ProductLevelPaginationDto dto = nebulaToolkitService.copyObjectByWhiteList(mdmProductLevelReqVo, ProductLevelPaginationDto.class, HashSet.class, ArrayList.class);
      Page<ProductLevelVo> page = mdmProductLevelVoService.findByConditions(pageable, dto);
      List<MdmProductLevelVo> mdmProductLevelVos = new ArrayList<>();
      if (CollectionUtils.isNotEmpty(page.getRecords())) {
        mdmProductLevelVos = page.getRecords().stream().map(productLevelVo -> {
          MdmProductLevelVo mdmProductLevelVo = nebulaToolkitService.copyObjectByWhiteList(productLevelVo, MdmProductLevelVo.class, HashSet.class, ArrayList.class);
          mdmProductLevelVo.setProductLevelTypeName(productLevelVo.getProductLevelType().getValue());
          return mdmProductLevelVo;
        }).collect(Collectors.toList());
      }
      return Result.ok(PageResult.<MdmProductLevelVo>builder()
          .data(mdmProductLevelVos)
          .count(page.getTotal())
          .build());
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "产品层级公用分页弹框")
  @PostMapping("/commonPageList")
  @Deprecated
  public Result<PageResult<MdmProductLevelVo>> commonPageList(@RequestBody MdmProductLevelDto mdmProductLevelReqVo) {
    try {
      mdmProductLevelReqVo = ObjectUtils.defaultIfNull(mdmProductLevelReqVo, new MdmProductLevelDto());
      mdmProductLevelReqVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
      Pageable pageable = PageRequest.of(mdmProductLevelReqVo.getPageNum(), mdmProductLevelReqVo.getPageSize());
      ProductLevelPaginationDto dto = nebulaToolkitService.copyObjectByWhiteList(mdmProductLevelReqVo, ProductLevelPaginationDto.class, HashSet.class, ArrayList.class);
      Page<ProductLevelVo> page = mdmProductLevelVoService.findByConditions(pageable, dto);
      List<MdmProductLevelVo> mdmProductLevelVos = new ArrayList<>();
      if (CollectionUtils.isNotEmpty(page.getRecords())) {
        mdmProductLevelVos = page.getRecords().stream().map(productLevelVo -> {
          MdmProductLevelVo mdmProductLevelVo = nebulaToolkitService.copyObjectByWhiteList(productLevelVo, MdmProductLevelVo.class, HashSet.class, ArrayList.class);
          mdmProductLevelVo.setProductLevelTypeName(productLevelVo.getProductLevelType().getValue());
          return mdmProductLevelVo;
        }).collect(Collectors.toList());
      }
      return Result.ok(PageResult.<MdmProductLevelVo>builder()
          .data(mdmProductLevelVos)
          .count(page.getTotal())
          .build());
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "详情", httpMethod = "GET")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "id", value = "ID", required = false, dataType = "String", paramType = "query"),
      @ApiImplicitParam(name = "productLevelCode", value = "产品层级编码", required = false, dataType = "String", paramType = "query")
  })
  @GetMapping("/detail")
  @Deprecated
  public Result<MdmProductLevelVo> detail(@RequestParam(value = "id", required = false) String id, @RequestParam(value = "productLevelCode", required = false) String productLevelCode) {
    try {
      MdmProductLevelVo mdmVo = null;
      ProductLevelVo vo = mdmProductLevelVoService.findDetailsById(id);
      if (vo != null) {
        mdmVo = nebulaToolkitService.copyObjectByWhiteList(vo, MdmProductLevelVo.class, HashSet.class, ArrayList.class);
        mdmVo.setProductLevelTypeName(vo.getProductLevelType().getValue());
      }
      return Result.ok(mdmVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "新增")
  @PostMapping("/save")
  @Deprecated
  public Result<?> save(@RequestBody MdmProductLevelDto mdmProductLevelReqVo) {
    try {
      mdmProductLevelReqVo = ObjectUtils.defaultIfNull(mdmProductLevelReqVo, new MdmProductLevelDto());
      ProductLevelCreateDto dto = nebulaToolkitService.copyObjectByWhiteList(mdmProductLevelReqVo, ProductLevelCreateDto.class, HashSet.class, ArrayList.class);
      mdmProductLevelVoService.create(dto);
      //删除缓存
      redisService.del(MDM_PRODUCT_LEVEL_LOCK_HASH);
      redisService.del(MDM_PRODUCT_LEVEL_SELF_HASH);
      redisService.del(MDM_PRODUCT_LEVEL_PARENT_HASH);
      redisService.del(MDM_PRODUCT_LEVEL_CHILDREN_HASH);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "更新")
  @PostMapping("/update")
  @Deprecated
  public Result<?> update(@RequestBody MdmProductLevelDto mdmProductLevelReqVo) {
    try {
      mdmProductLevelReqVo = ObjectUtils.defaultIfNull(mdmProductLevelReqVo, new MdmProductLevelDto());
      ProductLevelUpdateDto dto = nebulaToolkitService.copyObjectByWhiteList(mdmProductLevelReqVo, ProductLevelUpdateDto.class, HashSet.class, ArrayList.class);
      mdmProductLevelVoService.update(dto);
      //删除缓存
      redisService.del(MDM_PRODUCT_LEVEL_LOCK_HASH);
      redisService.del(MDM_PRODUCT_LEVEL_SELF_HASH);
      redisService.del(MDM_PRODUCT_LEVEL_PARENT_HASH);
      redisService.del(MDM_PRODUCT_LEVEL_CHILDREN_HASH);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "删除", httpMethod = "POST")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
  })
  @PostMapping("/delete")
  @Deprecated
  public Result<?> delete(@RequestBody List<String> ids) {
    try {
      mdmProductLevelVoService.deleteBatch(ids);
      //删除缓存
      redisService.del(MDM_PRODUCT_LEVEL_LOCK_HASH);
      redisService.del(MDM_PRODUCT_LEVEL_SELF_HASH);
      redisService.del(MDM_PRODUCT_LEVEL_PARENT_HASH);
      redisService.del(MDM_PRODUCT_LEVEL_CHILDREN_HASH);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "启用", httpMethod = "POST")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
  })
  @PostMapping("/enable")
  @Deprecated
  public Result<?> enable(@RequestBody List<String> ids) {
    try {
      mdmProductLevelVoService.enableBatch(ids);
      //删除缓存
      redisService.del(MDM_PRODUCT_LEVEL_LOCK_HASH);
      redisService.del(MDM_PRODUCT_LEVEL_SELF_HASH);
      redisService.del(MDM_PRODUCT_LEVEL_PARENT_HASH);
      redisService.del(MDM_PRODUCT_LEVEL_CHILDREN_HASH);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "禁用", httpMethod = "POST")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
  })
  @PostMapping("/disable")
  @Deprecated
  public Result<?> disable(@RequestBody List<String> ids) {
    try {
      mdmProductLevelVoService.disableBatch(ids);
      //删除缓存
      redisService.del(MDM_PRODUCT_LEVEL_LOCK_HASH);
      redisService.del(MDM_PRODUCT_LEVEL_SELF_HASH);
      redisService.del(MDM_PRODUCT_LEVEL_PARENT_HASH);
      redisService.del(MDM_PRODUCT_LEVEL_CHILDREN_HASH);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("重置降维编码")
  @PostMapping("/resetRuleCode")
  @Deprecated
  public Result<?> resetRuleCode() {
    try {
      mdmProductLevelVoService.updateRuleCode();
      //删除缓存
      redisService.del(MDM_PRODUCT_LEVEL_LOCK_HASH);
      redisService.del(MDM_PRODUCT_LEVEL_SELF_HASH);
      redisService.del(MDM_PRODUCT_LEVEL_PARENT_HASH);
      redisService.del(MDM_PRODUCT_LEVEL_CHILDREN_HASH);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "根据产品层级编码查询该产品层级及全部下级层级的编码", httpMethod = "GET")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "productLevelCode", value = "产品层级编码", required = true, dataType = "String", paramType = "query")
  })
  @GetMapping("/getAllChildrenProductLevelCodeList")
  @Deprecated
  public Result<List<String>> getAllChildrenProductLevelCodeList(@RequestParam("productLevelCode") String productLevelCode) {
    try {
      List<String> curAndChildrenCodesByCode =
          mdmProductLevelVoService.findCurAndChildrenCodesByCodes(Sets.newHashSet(productLevelCode));
      return Result.ok(curAndChildrenCodesByCode);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "产品层级下拉框(限制数量)")
  @PostMapping("/productLevelSelectList")
  @Deprecated
  public Result<List<MdmProductLevelSelectVo>> productLevelSelectList(@RequestBody MdmProductLevelSelectDto reqVo) {
    try {
      reqVo = ObjectUtils.defaultIfNull(reqVo, new MdmProductLevelSelectDto());
      Pageable pageable = PageRequest.of(1, null == reqVo.getPageSize() ? SELECT_BOX_OPTION_SIZE : reqVo.getPageSize());
      ProductLevelPaginationDto dto = nebulaToolkitService.copyObjectByWhiteList(reqVo, ProductLevelPaginationDto.class, HashSet.class, ArrayList.class);
      Page<ProductLevelVo> page = mdmProductLevelVoService.findByConditions(pageable, dto);
      List<MdmProductLevelSelectVo> mdmProductLevelVos = new ArrayList<>();
      if (CollectionUtils.isNotEmpty(page.getRecords())) {
        mdmProductLevelVos = page.getRecords().stream().map(productLevelVo -> nebulaToolkitService.copyObjectByWhiteList(productLevelVo, MdmProductLevelSelectVo.class, HashSet.class, ArrayList.class)).collect(Collectors.toList());
      }
      return Result.ok(mdmProductLevelVos);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "获取所有的产品层级")
  @GetMapping("/getAllProductLevelList")
  @Deprecated
  public Result<List<MdmProductLevelVo>> getAllProductLevelList() {
    try {
      List<ProductLevelVo> all = mdmProductLevelVoService.findAll();
      List<MdmProductLevelVo> mdmProductLevelVos = new ArrayList<>();
      if (CollectionUtils.isNotEmpty(all)) {
        mdmProductLevelVos = all.stream().map(productLevelVo -> {
          MdmProductLevelVo mdmProductLevelVo = nebulaToolkitService.copyObjectByWhiteList(productLevelVo, MdmProductLevelVo.class, HashSet.class, ArrayList.class);
          mdmProductLevelVo.setProductLevelTypeName(productLevelVo.getProductLevelType().getValue());
          return mdmProductLevelVo;
        }).collect(Collectors.toList());
      }
      return Result.ok(mdmProductLevelVos);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
