package com.biz.crm.mdm.business.product.level.local.deprecated.controller;

import com.biz.crm.business.common.local.entity.TenantFlagTreeOpEntity;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategy;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategyHolder;
import com.biz.crm.mdm.business.product.level.local.entity.ProductLevel;
import com.biz.crm.mdm.business.product.level.local.repository.ProductLevelRepository;
import com.biz.crm.mdm.business.product.level.sdk.common.constant.ProductLevelConstant;
import com.biz.crm.mdm.business.product.level.sdk.deprecated.vo.MdmProductLevelParentChildrenRedisVo;
import com.biz.crm.mdm.business.product.level.sdk.deprecated.vo.MdmProductLevelRedisVo;
import com.biz.crm.mdm.business.product.level.sdk.deprecated.vo.MdmProductLevelReloadRedisVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 产品层级表redis缓存数据查询请求接口类
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@RestController
@RequestMapping("/mdmProductLevelRedisController")
@Deprecated
@Api(tags = "MDM-产品层级redis")
public class MdmProductLevelRedisController {

  @Autowired(required = false)
  private ProductLevelRepository productLevelRepository;
  @Autowired(required = false)
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private TreeRuleCodeStrategyHolder treeRuleCodeStrategyHolder;

  /**
   * 根据产品层级编码集合获取产品层级详情redis缓存数据
   *
   * @param productLevelCodeList 产品层级编码集合
   * @return
   */
  @PostMapping("/findRedisListByProductLevelCodeList")
  @Deprecated
  public Result<List<MdmProductLevelRedisVo>> findRedisListByProductLevelCodeList(@RequestBody List<String> productLevelCodeList) {
    if (!CollectionUtils.isEmpty(productLevelCodeList)) {
      List<ProductLevel> list = productLevelRepository.lambdaQuery()
          .in(ProductLevel::getProductLevelCode, productLevelCodeList)
          .list();
      if (!CollectionUtils.isEmpty(list)) {
        Map<String, String> codeNameMap = new HashMap<>(16);
        Set<String> parentCodeSet = list.stream().filter(item -> StringUtils.isNotEmpty(item.getParentCode())).map(ProductLevel::getParentCode).collect(Collectors.toSet());
        if (!parentCodeSet.isEmpty()) {
          List<ProductLevel> parentCodeNameList = productLevelRepository.lambdaQuery()
              .in(ProductLevel::getProductLevelCode, parentCodeSet)
              .select(ProductLevel::getProductLevelCode, ProductLevel::getProductLevelName)
              .list();
          if (!CollectionUtils.isEmpty(parentCodeNameList)) {
            codeNameMap.putAll(parentCodeNameList.stream().collect(Collectors.toMap(ProductLevel::getProductLevelCode, ProductLevel::getProductLevelName)));
          }
        }
        return Result.ok(list.stream().map(item -> {
          MdmProductLevelRedisVo copy = nebulaToolkitService.copyObjectByWhiteList(item, MdmProductLevelRedisVo.class, HashSet.class, ArrayList.class);
          if (codeNameMap.containsKey(copy.getProductLevelCode())) {
            copy.setProductLevelName(codeNameMap.get(copy.getProductLevelCode()));
          }
          return copy;
        }).collect(Collectors.toList()));
      }
    }
    return Result.ok((new ArrayList<>()));
  }

  /**
   * 根据产品层级编码集合获取产品层级上级redis缓存数据
   *
   * @param productLevelCodeList 产品层级编码集合
   * @return
   */
  @PostMapping("/findRedisProductLevelParentListByCodeList")
  @Deprecated
  public Result<List<MdmProductLevelParentChildrenRedisVo>> findRedisProductLevelParentListByCodeList(@RequestBody List<String> productLevelCodeList) {
    if (!CollectionUtils.isEmpty(productLevelCodeList)) {
      List<ProductLevel> list = productLevelRepository.lambdaQuery()
          .in(ProductLevel::getProductLevelCode, productLevelCodeList)
          .select(ProductLevel::getProductLevelCode, ProductLevel::getRuleCode)
          .list();
      if (!CollectionUtils.isEmpty(list)) {
        TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
        Set<String> parentRuleCodes =
            treeRuleCodeStrategy.findParentRuleCodeByRuleCodesExcludeAnySelf(
                ProductLevelConstant.RULE_CODE_LENGTH, list.stream().map(ProductLevel::getRuleCode).collect(Collectors.toList()));
        List<ProductLevel> parentList = productLevelRepository.lambdaQuery()
            .in(ProductLevel::getRuleCode, parentRuleCodes)
            .list();
        Set<String> collect = parentList.stream().filter(item -> StringUtils.isNotEmpty(item.getParentCode())).map(ProductLevel::getParentCode).collect(Collectors.toSet());
        Map<String, String> parentProductLevelCodeNameMap = new HashMap<>(16);
        if (!collect.isEmpty()) {
          parentProductLevelCodeNameMap.putAll(productLevelRepository.lambdaQuery()
              .in(ProductLevel::getProductLevelCode, collect)
              .select(ProductLevel::getProductLevelCode, ProductLevel::getProductLevelName)
              .list()
              .stream()
              .collect(Collectors.toMap(ProductLevel::getProductLevelCode, ProductLevel::getProductLevelName)));
        }
        List<MdmProductLevelRedisVo> parentRedisVoList = parentList.stream().map(item -> {
          MdmProductLevelRedisVo copy = nebulaToolkitService.copyObjectByWhiteList(item, MdmProductLevelRedisVo.class, HashSet.class, ArrayList.class);
          if (StringUtils.isNotEmpty(copy.getParentCode())) {
            if (parentProductLevelCodeNameMap.containsKey(copy.getParentCode())) {
              copy.setParentName(parentProductLevelCodeNameMap.get(copy.getParentCode()));
            }
          }
          return copy;
        }).collect(Collectors.toList());
        List<MdmProductLevelParentChildrenRedisVo> result = new ArrayList<>();
        for (ProductLevel item :
            parentList) {
          MdmProductLevelParentChildrenRedisVo redisVo = new MdmProductLevelParentChildrenRedisVo();
          redisVo.setProductLevelCode(item.getProductLevelCode());
          redisVo.setList(parentRedisVoList.stream().filter(x -> item.getRuleCode().startsWith(x.getRuleCode())).collect(Collectors.toList()));
          result.add(redisVo);
        }
        return Result.ok(result);
      }
    }
    return Result.ok(new ArrayList<>());
  }

  /**
   * 根据产品层级编码集合获取产品层级下级redis缓存数据
   *
   * @param productLevelCodeList 产品层级编码集合
   * @return
   */
  @PostMapping("/findRedisProductLevelChildrenListByCodeList")
  @Deprecated
  public Result<List<MdmProductLevelParentChildrenRedisVo>> findRedisProductLevelChildrenListByCodeList(@RequestBody List<String> productLevelCodeList) {
    if (!CollectionUtils.isEmpty(productLevelCodeList)) {
      List<ProductLevel> productLevelList = productLevelRepository.lambdaQuery()
          .in(ProductLevel::getProductLevelCode, productLevelCodeList)
          .select(ProductLevel::getProductLevelCode, ProductLevel::getRuleCode)
          .list();
      if (!CollectionUtils.isEmpty(productLevelList)) {
        List<String> ruleCodes = productLevelList.stream().map(TenantFlagTreeOpEntity::getRuleCode).collect(Collectors.toList());
        List<ProductLevel> childrenList =
            productLevelRepository.findCurAndChildrenByRuleCodeList(ruleCodes, EnableStatusEnum.ENABLE.getCode(), TenantUtils.getTenantCode());
        if (!CollectionUtils.isEmpty(childrenList)) {
          List<MdmProductLevelRedisVo> redisList = Lists.newArrayList(this.nebulaToolkitService.copyCollectionByWhiteList(childrenList
              , ProductLevel.class, MdmProductLevelRedisVo.class, HashSet.class, ArrayList.class));
          List<MdmProductLevelParentChildrenRedisVo> resultList = new ArrayList<>();
          for (ProductLevel item :
              productLevelList) {
            MdmProductLevelParentChildrenRedisVo redisVo = new MdmProductLevelParentChildrenRedisVo();
            redisVo.setProductLevelCode(item.getProductLevelCode());
            redisVo.setList(redisList.stream().filter(x -> x.getRuleCode().startsWith(item.getRuleCode())).collect(Collectors.toList()));
            resultList.add(redisVo);
          }
          return Result.ok(resultList);
        }
      }
    }
    return Result.ok(new ArrayList<>());
  }

  /**
   * 获取全部产品层级redis缓存数据
   *
   * @return
   */
  @PostMapping("/findRedisReloadList")
  @Deprecated
  public Result<List<MdmProductLevelReloadRedisVo>> findRedisReloadList() {
    final List<ProductLevel> all = productLevelRepository.lambdaQuery().list();
    if (!CollectionUtils.isEmpty(all)) {
      final Map<String, String> productLevelCodeNameMap = all.stream().collect(Collectors.toMap(ProductLevel::getProductLevelCode, ProductLevel::getProductLevelName));
      final List<MdmProductLevelRedisVo> redisList = all.stream().map(item -> {
        MdmProductLevelRedisVo copy = nebulaToolkitService.copyObjectByWhiteList(item, MdmProductLevelRedisVo.class, HashSet.class, ArrayList.class);
        if (StringUtils.isNotEmpty(copy.getParentCode())) {
          copy.setParentName(productLevelCodeNameMap.get(copy.getParentCode()));
        }
        return copy;
      }).collect(Collectors.toList());
      return Result.ok(redisList.stream().map(item -> {
        MdmProductLevelReloadRedisVo redisVo = new MdmProductLevelReloadRedisVo();
        redisVo.setProductLevelCode(item.getProductLevelCode());
        redisVo.setSelf(item);
        redisVo.setParentList(redisList.stream().filter(x -> item.getRuleCode().startsWith(x.getRuleCode())).collect(Collectors.toList()));
        redisVo.setChildrenList(redisList.stream().filter(x -> x.getRuleCode().startsWith(item.getRuleCode())).collect(Collectors.toList()));
        return redisVo;
      }).collect(Collectors.toList()));
    }
    return Result.ok(new ArrayList<>());
  }

}
