package com.biz.crm.mdm.business.product.level.local.notifier;
/**
 * Created by Bao Hongbin on 2021-10-12 17:15.
 */

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.mdm.business.product.level.sdk.dto.ProductLevelEventDto;
import com.biz.crm.mdm.business.product.level.sdk.event.ProductLevelEventListener;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @program: crm
 * @description: TODO 推送作日志（目前尚无记录日志功能，该功能将在后续改造中实现，目前无法实现推送，暂时记录为info级系统日志）
 * @author: Bao Hongbin
 * @create: 2021-10-12 17:15
 **/
@Component
@Slf4j
public class ProductLevelEventLogListenerImpl implements ProductLevelEventListener {

  @Autowired(required = false)
  private CrmBusinessLogVoService crmBusinessLogVoService;

  /**
   * 新增产品层级记录日志
   *
   * @param productLevelVos
   */
  @Override
  public void onBatchCreate(List<ProductLevelVo> productLevelVos) {
    log.info("新增产品层级信息：{}", JsonUtils.obj2JsonString(productLevelVos));
    //--记录日志 添加时间 2022年12月27日10:48:51--
    if (CollectionUtils.isEmpty(productLevelVos)) {
      return;
    }
    productLevelVos.forEach(productLevelVo -> {
      String onlyKey = productLevelVo.getId();
      CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
      crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
      crmBusinessLogDto.setOnlyKey(onlyKey);
      crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
      crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
      crmBusinessLogDto.setOldObject(null);
      crmBusinessLogDto.setNewObject(productLevelVo);
      crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    });
  }

  /**
   * 更新产品层级记录日志
   *
   * @param productLevelVos
   */
  @Override
  public void onBatchUpdate(List<ProductLevelVo> productLevelVos) {
    log.info("更新产品层级信息：{}", JsonUtils.obj2JsonString(productLevelVos));
    //--记录日志 添加时间 2022年12月27日10:48:51--
    if (CollectionUtils.isNotEmpty(productLevelVos) && productLevelVos.size() > 1) {
      // 索引0 ：oldObj  索引1 :newObj
      ProductLevelVo oldObj = productLevelVos.get(0);
      ProductLevelVo newObj = productLevelVos.get(1);
      String onlyKey = newObj.getId();
      CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
      crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
      crmBusinessLogDto.setOnlyKey(onlyKey);
      crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
      crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
      crmBusinessLogDto.setOldObject(oldObj);
      crmBusinessLogDto.setNewObject(newObj);
      crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }
  }

  /**
   * 删除产品层级记录日志
   *
   * @param productLevelVos
   */
  @Override
  public void onBatchDelete(List<ProductLevelVo> productLevelVos) {
    log.info("删除产品层级信息：{}", JsonUtils.obj2JsonString(productLevelVos));
    //--记录日志 添加时间 2022年12月27日10:48:51--
    if (CollectionUtils.isEmpty(productLevelVos)) {
      return;
    }
    productLevelVos.forEach(productLevelVo -> {
      String onlyKey = productLevelVo.getId();
      CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
      crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
      crmBusinessLogDto.setOnlyKey(onlyKey);
      crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
      crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
      crmBusinessLogDto.setOldObject(productLevelVo);
      crmBusinessLogDto.setNewObject(null);
      crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    });
  }

  /**
   * 启用产品层级记录日志
   *
   * @param productLevelVos 新数据
   */
  @Override
  public void onBatchEnable(List<ProductLevelVo> productLevelVos) {
    log.info("启用产品层级信息：{}", JsonUtils.obj2JsonString(productLevelVos));
    //--记录日志 添加时间 2022年12月27日10:48:51--
    if (CollectionUtils.isEmpty(productLevelVos)) {
      return;
    }
    productLevelVos.forEach(productLevelVo -> {
      String onlyKey = productLevelVo.getId();
      ProductLevelVo oldObj = new ProductLevelVo();
      oldObj.setId(onlyKey);
      oldObj.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
      ProductLevelVo newObj = new ProductLevelVo();
      newObj.setId(onlyKey);
      newObj.setEnableStatus(productLevelVo.getEnableStatus());
      CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
      crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
      crmBusinessLogDto.setOnlyKey(onlyKey);
      crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
      crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
      crmBusinessLogDto.setOldObject(oldObj);
      crmBusinessLogDto.setNewObject(newObj);
      crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    });
  }

  /**
   * 禁用产品层级记录日志
   *
   * @param productLevelVos 新数据
   */
  @Override
  public void onBatchDisable(List<ProductLevelVo> productLevelVos) {
    log.info("禁用产品层级信息：{}", JsonUtils.obj2JsonString(productLevelVos));
    //--记录日志 添加时间 2022年12月27日10:48:51--
    if (CollectionUtils.isNotEmpty(productLevelVos)) {
      productLevelVos.forEach(productLevelVo -> {
        String onlyKey = productLevelVo.getId();
        ProductLevelVo oldObj = new ProductLevelVo();
        oldObj.setId(onlyKey);
        oldObj.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        ProductLevelVo newObj = new ProductLevelVo();
        newObj.setId(onlyKey);
        newObj.setEnableStatus(productLevelVo.getEnableStatus());
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(oldObj);
        crmBusinessLogDto.setNewObject(newObj);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
      });
    }
  }
}
