package com.biz.crm.mdm.business.product.level.local.service.internal;
/**
 * Created by Bao Hongbin on 2021-10-14 14:48.
 */

import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategy;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategyHolder;
import com.biz.crm.mdm.business.product.level.local.entity.ProductLevel;
import com.biz.crm.mdm.business.product.level.local.repository.ProductLevelRepository;
import com.biz.crm.mdm.business.product.level.local.service.ProductLevelVoService;
import com.biz.crm.mdm.business.product.level.sdk.common.constant.ProductLevelConstant;
import com.biz.crm.mdm.business.product.level.sdk.dto.RelateProductLevelCodeQueryDto;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @program: crm
 * @description: 产品层级vo SDK 服务实现
 * @author: Bao Hongbin
 * @create: 2021-10-14 14:48
 **/
@Service
public class ProductLevelVoSdkServiceImpl implements ProductLevelVoSdkService {
  @Autowired(required = false)
  private ProductLevelVoService productLevelVoService;
  @Autowired(required = false)
  private ProductLevelRepository productLevelRepository;
  @Autowired(required = false)
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private TreeRuleCodeStrategyHolder treeRuleCodeStrategyHolder;

  @Override
  public ProductLevelVo findDetailsById(String id) {
    return productLevelVoService.findDetailsById(id);
  }

  @Override
  public List<ProductLevelVo> findListByIds(List<String> ids) {
    if (CollectionUtils.isEmpty(ids)) {
      return new ArrayList<>();
    }
    List<ProductLevel> productLevels = productLevelRepository.findListByIds(ids);
    return Lists.newArrayList(nebulaToolkitService.copyCollectionByWhiteList(productLevels, ProductLevel.class
        , ProductLevelVo.class, HashSet.class, ArrayList.class));
  }

  @Override
  public ProductLevelVo findDetailsByCode(String code) {
    if (StringUtils.isEmpty(code)) {
      return null;
    }
    ProductLevel productLevel = productLevelRepository.findDetailsByCode(code);
    if (null == productLevel) {
      return null;
    }
    return nebulaToolkitService.copyObjectByWhiteList(
        productLevel, ProductLevelVo.class, HashSet.class, ArrayList.class);
  }

  @Override
  public List<ProductLevelVo> findListByCodes(List<String> codes) {
    if (CollectionUtils.isEmpty(codes)) {
      return new ArrayList<>();
    }
    List<ProductLevel> productLevels = productLevelRepository.findListByCodes(codes);
    return Lists.newArrayList(nebulaToolkitService.copyCollectionByWhiteList(productLevels, ProductLevel.class
        , ProductLevelVo.class, HashSet.class, ArrayList.class));
  }

  @Override
  public List<String> findCurAndChildrenCodesByCodes(Set<String> productLevelCodeSet) {
    return productLevelVoService.findCurAndChildrenCodesByCodes(productLevelCodeSet);
  }

  @Override
  public List<ProductLevelVo> findByProductLevelType(String productLevelType) {
    if (StringUtils.isBlank(productLevelType)) {
      return Lists.newLinkedList();
    }
    List<ProductLevel> productLevels = this.productLevelRepository.findByProductLevelType(productLevelType, TenantUtils.getTenantCode());
    return (List<ProductLevelVo>) nebulaToolkitService.copyCollectionByWhiteList(productLevels, ProductLevel.class
        , ProductLevelVo.class, HashSet.class, ArrayList.class);
  }

  @Override
  public Map<String, List<ProductLevelVo>> findCurAndParentByCodes(List<String> codes) {
    Map<String, List<ProductLevelVo>> resultMap = Maps.newHashMap();
    if (CollectionUtils.isEmpty(codes)) {
      return resultMap;
    }
    List<ProductLevel> productLevels = productLevelRepository.findListByCodes(codes);
    if (CollectionUtils.isEmpty(productLevels)) {
      return resultMap;
    }
    resultMap = productLevels.stream().collect(Collectors.toMap(ProductLevel::getProductLevelCode, t -> {
      ProductLevelVo vo = nebulaToolkitService.copyObjectByWhiteList(
          t, ProductLevelVo.class, HashSet.class, ArrayList.class);
      return Lists.newArrayList(vo);
    }, (a,b) -> b));
    List<String> ruleCodes = productLevels.stream().map(ProductLevel::getRuleCode).collect(Collectors.toList());
    TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
    Set<String> parentRuleCodes = treeRuleCodeStrategy.findParentRuleCodesByRuleCodesExcludeSelf(ProductLevelConstant.RULE_CODE_LENGTH, ruleCodes);
    if (CollectionUtils.isEmpty(parentRuleCodes)) {
      return resultMap;
    }
    //3.如果存在未启用的上级层级，不能启用当前层级
    List<ProductLevel> parentList = this.productLevelRepository.findListByRuleCodes(parentRuleCodes);
    if (CollectionUtils.isEmpty(parentList)) {
      return resultMap;
    }
    //父级层级映射 key-ruleCode value-productLevelVo
    Map<String, ProductLevelVo> parentMap = parentList.stream().collect(Collectors.toMap(ProductLevel::getRuleCode, t -> nebulaToolkitService.copyObjectByWhiteList(
        t, ProductLevelVo.class, HashSet.class, ArrayList.class), (a, b) -> b));
    resultMap.values().forEach(productLevelVos -> {
      ProductLevelVo productLevelVo = productLevelVos.get(0);
      Set<String> pRoleCodes = treeRuleCodeStrategy.findParentRuleCodesByRuleCodeExcludeSelf(ProductLevelConstant.RULE_CODE_LENGTH, productLevelVo.getRuleCode());
      pRoleCodes.forEach(ruleCode -> {
        ProductLevelVo levelVo = parentMap.get(ruleCode);
        if (Objects.nonNull(levelVo)) {
          productLevelVos.add(levelVo);
        }
      });
    });
    return resultMap;
  }

  @Override
  public Map<String, String> findByRelateProductLevelCodeQueryDto(
      RelateProductLevelCodeQueryDto dto) {
    if (Objects.isNull(dto) || CollectionUtils.isEmpty(dto.getProductLevelCodeSet())) {
      return Maps.newHashMap();
    }
    dto.setSearchType(Optional.ofNullable(dto.getSearchType()).orElse(0));
    List<ProductLevel> productLevelList =
        this.productLevelRepository.findDetailsByCodes(dto.getProductLevelCodeSet());
    if (CollectionUtils.isEmpty(productLevelList)) {
      return Maps.newHashMap();
    }
    if (dto.getSearchType() == 0) {
      return productLevelList.stream()
          .filter(a -> StringUtils.isNoneBlank(a.getProductLevelCode(), a.getRuleCode()))
          .collect(Collectors.toMap(ProductLevel::getProductLevelCode, ProductLevel::getRuleCode, (a, b) -> a));
    }
    List<String> ruleCodeList =
        productLevelList.stream()
            .filter(a -> StringUtils.isNotBlank(a.getRuleCode()))
            .map(ProductLevel::getRuleCode)
            .distinct()
            .collect(Collectors.toList());
    if (CollectionUtils.isEmpty(ruleCodeList)) {
      return Maps.newHashMap();
    }

    TreeRuleCodeStrategy treeRuleCodeStrategy = treeRuleCodeStrategyHolder.getStrategy(null);
    if (dto.getSearchType() > 0) {
      Set<String> ruleCodeSet =
          treeRuleCodeStrategy.findParentRuleCodesByRuleCodesExcludeSelf(
              ProductLevelConstant.RULE_CODE_LENGTH, ruleCodeList);
      if (CollectionUtils.isEmpty(ruleCodeSet)) {
        ruleCodeSet = Sets.newHashSet();
      }
      ruleCodeSet.addAll(ruleCodeList);
      if (CollectionUtils.isNotEmpty(ruleCodeSet)) {
        final List<ProductLevel> cur = this.productLevelRepository.findListByRuleCodes(ruleCodeSet);
        if (CollectionUtils.isEmpty(cur)) {
          return Maps.newHashMap();
        }
        return cur.stream()
            .collect(Collectors.toMap(ProductLevel::getProductLevelCode, ProductLevel::getRuleCode, (a, b) -> a));
      }
    } else {
      final List<ProductLevel> cur =
          this.productLevelRepository.findCurAndChildrenByRuleCodeList(ruleCodeList, null);
      if (CollectionUtils.isEmpty(cur)) {
        return Maps.newHashMap();
      }
      return cur.stream().collect(Collectors.toMap(ProductLevel::getProductLevelCode, ProductLevel::getRuleCode, (a, b) -> a));
    }
    return Maps.newHashMap();
  }
}
