package com.biz.crm.mdm.business.product.level.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.product.level.local.entity.ProductLevel;
import com.biz.crm.mdm.business.product.level.local.service.ProductLevelService;
import com.biz.crm.mdm.business.product.level.sdk.dto.ProductLevelDto;
import com.biz.crm.mdm.business.product.level.sdk.dto.ProductLevelEditDto;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelCodeVo;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author chuyi
 * @version 1.0
 * @description: TODO
 * @date 2023/7/3 10:04
 */
@RestController
@Slf4j
@RequestMapping(("/v1/external/product"))
@Api(tags = "同步产品相关信息")
public class ProductLevelController {

     @Autowired(required = false)
     private ProductLevelService productLevelService;

     @PostMapping("findByConditions")
     @ApiOperation(value = "分页查询")
    public Result<Page<ProductLevelCodeVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                             @ApiParam("分页参数") ProductLevelDto productLevelDto){
         try {
             Page<ProductLevelCodeVo> page = this.productLevelService.findByConditions(pageable,productLevelDto);
             return Result.ok(page);
         }catch (RuntimeException e){
             log.error(e.getMessage(),e);
             return Result.error(e.getMessage());
         }
     }

     @PostMapping("create")
     @ApiOperation(value = "修改或新增产品层级")
    public Result<?> saveOrUpdate(@ApiParam(value = "同步产品层级参数") @RequestBody List<ProductLevelEditDto> dtos) {
         try {
             this.productLevelService.create(dtos);
             return Result.ok();
         }catch (RuntimeException e){
             log.error(e.getMessage(),e);
             return Result.error(e.getMessage());
         }
     }
     @DeleteMapping("delete")
     @ApiOperation(value = "删除产品层级")
     public Result<?> deleteById(@RequestBody List<String> ids){
         try {
             this.productLevelService.deleteByIds(ids);
             return Result.ok("删除成功!");
         }catch (RuntimeException e){
             log.error(e.getMessage(),e);
             return Result.error(e.getMessage());
         }
     }

     @PatchMapping("update")
     @ApiOperation(value = "修改产品层级")
     public Result<?> updateById(@RequestBody List<ProductLevelEditDto> dtos){
         try {
             this.productLevelService.updateById(dtos);
             return Result.ok("修改成功!");
         }catch (RuntimeException e){
             log.error(e.getMessage(),e);
             return Result.error(e.getMessage());
         }
     }
}
