package com.biz.crm.mdm.business.product.level.local.controller;
/**
 * Created by Bao Hongbin on 2021-10-28 17:43.
 */

import com.biz.crm.business.common.sdk.dto.TreeDto;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.vo.TreeVo;
import com.biz.crm.mdm.business.product.level.local.service.ProductLevelTreeVoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @program: crm
 * @description: 产品层级：TreeVo：产品层级树
 * @author: Bao Hongbin
 * @create: 2021-10-28 17:43
 **/

@Api(tags = "产品层级：TreeVo：产品层级树")
@Slf4j
@RestController
@RequestMapping("/v1/productLevel/tree")
public class ProductLevelTreeVoController {
  @Autowired(required = false)
  private ProductLevelTreeVoService productLevelTreeVoService;

  @ApiOperation(value = "产品层级树")
  @GetMapping
  public Result<List<TreeVo>> findTree(@PageableDefault(50) Pageable pageable, @ApiParam(name = "treeDto", value = "查询Dto") TreeDto treeDto) {
    try {
      List<TreeVo> result = this.productLevelTreeVoService.findTree(pageable,treeDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
