package com.biz.crm.mdm.business.product.level.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.product.level.sdk.dto.ProductLevelDto;
import com.biz.crm.mdm.business.product.level.sdk.dto.RelateProductLevelCodeQueryDto;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import oracle.jdbc.proxy.annotation.Post;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author sunx
 * @date 2021/11/17
 */
@Api(tags = "产品层级：ProductLevelVo：与产品层级相关的内容")
@Slf4j
@RestController
@RequestMapping("/v1/productLevel/productLevel")
public class ProductLevelVoSdkController {

  @Autowired(required = false)
  private ProductLevelVoSdkService productLevelVoSdkService;

  /**
   * 根据层级编码获取商品层级明细信息
   *
   * @param codes
   * @return
   */
  @ApiOperation(value = "根据层级编码获取商品层级明细信息")
  @GetMapping("/findListByCodes")
  public Result<List<ProductLevelVo>> findListByCodes(@RequestParam("codes") List<String> codes) {
    try {
      List<ProductLevelVo> list = this.productLevelVoSdkService.findListByCodes(codes);
      return Result.ok(list);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 按照ProductLevel的productLevelCode编码，查询所有的父节点信息
   *
   * @param productLevelCode
   * @return
   */
  @ApiOperation(value = "按照ProductLevel的productLevelCode编码，查询所有的父节点信息")
  @GetMapping("/findAllParentsByProductLevelCode")
  public Result<List<ProductLevelVo>> findAllParentsByProductLevelCode(@RequestParam("productLevelCode") String productLevelCode) {
    try {
      List<ProductLevelVo> list = this.productLevelVoSdkService.findAllParentsByProductLevelCode(productLevelCode);
      return Result.ok(list);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据产品层级类型获取产品层级信息
   *
   * @param productLevelType 产品层级类型
   * @return 产品层级信息
   */
  @ApiOperation(value = "根据产品层级类型获取产品层级信息")
  @GetMapping("/findByProductLevelType")
  public Result<List<ProductLevelVo>> findByProductLevelType(@RequestParam("productLevelType") String productLevelType) {
    try {
      List<ProductLevelVo> list = this.productLevelVoSdkService.findByProductLevelType(productLevelType);
      return Result.ok(list);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过产品层级编码集合获取当前编码对应的产品层级以及其上级产品层级
   *
   * @param codes 产品层级编码
   * @return 产品层级映射(key_产品层级编码, value_当前编码对应的产品层级以及其上级产品层级列表)
   */
  @ApiOperation(value = "通过产品层级编码集合获取当前编码对应的产品层级以及其上级产品层级")
  @GetMapping("/findCurAndParentByCodes")
  public Result<Map<String, List<ProductLevelVo>>> findCurAndParentByCodes(@RequestParam("codes") List<String> codes) {
    try {
      Map<String, List<ProductLevelVo>> map = this.productLevelVoSdkService.findCurAndParentByCodes(codes);
      return Result.ok(map);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "通过产品层级编码集合获取当前编码对应的产品层级以及其下级产品层级")
  @GetMapping("/findCurAndChildrenCodesByCodes")
  public Result<List<String>> findCurAndChildrenCodesByCodes(@RequestParam("codes") Set<String> productLevelCodeSet) {
    try {
      List<String> curAndChildrenCodesByCodes = this.productLevelVoSdkService.findCurAndChildrenCodesByCodes(productLevelCodeSet);
      return Result.ok(curAndChildrenCodesByCodes);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 获取产品层级对应的未删除的上级或下级编码
   *
   * @param dto
   * @return
   */
  @ApiOperation(value = "获取产品层级对应的未删除的上级或下级编码")
  @GetMapping("/findByRelateProductLevelCodeQueryDto")
  public Result<Map<String, String>> findByRelateProductLevelCodeQueryDto(
      RelateProductLevelCodeQueryDto dto) {
    try {
      return Result.ok(this.productLevelVoSdkService.findByRelateProductLevelCodeQueryDto(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @PostMapping("/findLeafChild")
  @ApiOperation(value = "获取产品层级叶子节点下拉数据")
  public Result<List<ProductLevelVo>>
  findLeafChild(@RequestBody ProductLevelDto dto){
    try {
      return Result.ok(this.productLevelVoSdkService.findLeafChild(dto));
    }catch (Exception e){
      log.error(e.getMessage(),e);
      return Result.error(e.getMessage());
    }
  }
  @PostMapping("findByCodeAndName")
  @ApiOperation(value = "根据产品编码和产品名称查询")
  public Result<List<ProductLevelVo>> findByCodeAndName(@RequestBody ProductLevelDto dto){
    try {
      List<ProductLevelVo> list =this.productLevelVoSdkService.findByCodeAndName(dto);
      return Result.ok(list);
    } catch (RuntimeException e) {
      log.error(e.getMessage(),e);
      return Result.error(e.getMessage());
    }
  }
}
