package com.biz.crm.mdm.business.product.level.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.dto.TreeDto;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategy;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategyHolder;
import com.biz.crm.mdm.business.product.level.local.entity.ProductLevel;
import com.biz.crm.mdm.business.product.level.local.repository.ProductLevelRepository;
import com.biz.crm.mdm.business.product.level.local.service.ProductLevelService;
import com.biz.crm.mdm.business.product.level.sdk.common.constant.ProductLevelConstant;
import com.biz.crm.mdm.business.product.level.sdk.dto.ProductLevelDto;
import com.biz.crm.mdm.business.product.level.sdk.dto.ProductLevelEditDto;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelCodeVo;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * @author chuyi
 * @version 1.0
 * @description: TODO
 * @date 2023/7/3 10:19
 */
@Service
public class ProductLevelServiceImpl implements ProductLevelService {
    @Autowired(required = false)
    private ProductLevelRepository productLevelRepository;


    @Override
    public Page<ProductLevelCodeVo> findByConditions(Pageable pageable, ProductLevelDto productLevelDto) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1,50));
        productLevelDto = Optional.ofNullable(productLevelDto).orElse(new ProductLevelDto());
        productLevelDto.setTenantCode(TenantUtils.getTenantCode());
        return this.productLevelRepository.findProductLevelByConditions(pageable,productLevelDto);
    }

    @Override
    @Transactional
    public void create(List<ProductLevelEditDto> dtos) {
        //参数判空 并修改
        this.createForm(dtos);
    }

    @Override
    @Transactional
    public void deleteByIds(List<String> ids) {
        Validate.isTrue(CollectionUtils.isNotEmpty(ids),"请求参数不能为空");
        this.productLevelRepository.deleteByIds(ids);
    }

    @Override
    @Transactional
    public void updateById(List<ProductLevelEditDto> dtos) {
        this.editForm(dtos);
    }

    private void editForm(List<ProductLevelEditDto> dtos) {
        Validate.isTrue(CollectionUtils.isNotEmpty(dtos),"请求参数不能为空!");
        dtos.stream().forEach(o->{
            Validate.notBlank(o.getCode(),"产品分类编码不能为空");
            Validate.notBlank(o.getName(),"产品分类名称不能为空");
            Validate.notBlank(o.getParentId(),"父类ID不能为空");
            Validate.notBlank(o.getId(),"请求ID不能为空");
        });
        List<ProductLevel> list = new ArrayList<>();
        int levelNum=1;
        dtos.stream().forEach(o->{
            ProductLevel productLevel = new ProductLevel();
            productLevel.setParentId(o.getParentId());
            productLevel.setProductLevelCode(o.getCode());
            productLevel.setProductLevelName(o.getName());
            productLevel.setId(o.getId());
            if (o.getParentId().equals("-1")){
                productLevel.setLevelNum(levelNum);
            }else {
                ProductLevel level = this.productLevelRepository.findDetailsById(o.getParentId());
                Validate.isTrue(level!=null,"不存在的父类ID");
                productLevel.setLevelNum(level.getLevelNum()+levelNum);
            }
            productLevel.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            productLevel.setTenantCode(TenantUtils.getTenantCode());
            productLevel.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            list.add(productLevel);
        });
        this.productLevelRepository.updateBatchById(list);
    }

    private void createForm(List<ProductLevelEditDto> dtos) {
        Validate.isTrue(CollectionUtils.isNotEmpty(dtos),"请求参数不能为空");
        dtos.stream().forEach(o->{
                Validate.notBlank(o.getCode(),"产品分类编码不能为空");
                Validate.notBlank(o.getName(),"产品分类名称不能为空");
                Validate.notBlank(o.getParentId(),"父类ID不能为空");
        });
        List<ProductLevel> list = new ArrayList<>();
        int levelNum=1;
        dtos.stream().forEach(o->{
            ProductLevel productLevel = new ProductLevel();
            productLevel.setParentId(o.getParentId());
            productLevel.setProductLevelCode(o.getCode());
            productLevel.setProductLevelName(o.getName());
            ProductLevel level = this.productLevelRepository.findDetailsById(o.getParentId());
            productLevel.setId(o.getId());
            if (o.getParentId().equals("-1")){
                productLevel.setLevelNum(levelNum);
            }else {
                productLevel.setLevelNum(level.getLevelNum()+levelNum);
            }
            productLevel.setRuleCode(o.getCode());
            productLevel.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            productLevel.setTenantCode(TenantUtils.getTenantCode());
            productLevel.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            list.add(productLevel);
        });
        this.productLevelRepository.saveOrUpdateBatch(list);
    }
}
