package com.biz.crm.mdm.business.product.level.local.service.internal;
/**
 * Created by Bao Hongbin on 2021-10-28 18:07.
 */

import com.biz.crm.business.common.sdk.dto.TreeDto;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategy;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategyHolder;
import com.biz.crm.business.common.sdk.utils.TreeUtil;
import com.biz.crm.business.common.sdk.vo.TreeVo;
import com.biz.crm.mdm.business.product.level.local.entity.ProductLevel;
import com.biz.crm.mdm.business.product.level.local.repository.ProductLevelRepository;
import com.biz.crm.mdm.business.product.level.local.service.ProductLevelTreeVoService;
import com.biz.crm.mdm.business.product.level.sdk.common.constant.ProductLevelConstant;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @program: crm
 * @description: 产品层级载树服务实现
 * @author: Bao Hongbin
 * @create: 2021-10-28 18:07
 **/
@Service
public class ProductLevelTreeVoServiceImpl implements ProductLevelTreeVoService {
  @Autowired(required = false)
  private ProductLevelRepository productLevelRepository;
  @Autowired(required = false)
  private TreeRuleCodeStrategyHolder treeRuleCodeStrategyHolder;


  @Override
  public List<TreeVo> findTree(Pageable pageable, TreeDto treeDto) {
    treeDto = Optional.ofNullable(treeDto).orElse(new TreeDto());
    List<TreeVo> tree = new ArrayList<>();
    List<ProductLevel> list =  productLevelRepository.findListLikeName(treeDto);
    if (CollectionUtils.isEmpty(list)) {
      return tree;
    }
    if (StringUtils.isNotEmpty(treeDto.getName())) {
      //查询所有符合的
      TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
      Set<String> set = treeRuleCodeStrategy.findParentRuleCodeByRuleCodes(
          ProductLevelConstant.RULE_CODE_LENGTH, list.stream().map(ProductLevel::getRuleCode).collect(Collectors.toList()));
      if (!CollectionUtils.isEmpty(set)) {
        List<List<String>> partition = Lists.partition(new ArrayList<>(set), 500);
        list = new ArrayList<>();
        for (List<String> part : partition) {
          list.addAll(productLevelRepository.findListByRuleCodes(new HashSet<>(part)));
        }
      }
    }
    List<TreeVo> collect = list.stream().map(x -> {
      TreeVo treeVo = new TreeVo();
      treeVo.setId(x.getId());
      treeVo.setParentCode(x.getParentCode());
      treeVo.setCode(x.getProductLevelCode());
      treeVo.setName(x.getProductLevelName());
      return treeVo;
    }).collect(Collectors.toList());
    tree = TreeUtil.generateTreeByParentCode(collect);
    if (StringUtils.isNotEmpty(treeDto.getExcludeCodeAndChildren())) {
      TreeUtil.excludeCodeAndChildren(tree, treeDto.getExcludeCodeAndChildren());
    }
    return tree;
  }


}
