/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.product.level.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.product.level.local.service.ProductLevelService;
import com.biz.crm.mdm.business.product.level.sdk.dto.ProductLevelDto;
import com.biz.crm.mdm.business.product.level.sdk.dto.ProductLevelEditDto;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelCodeVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/external/product"})
@Api(tags={"\u540c\u6b65\u4ea7\u54c1\u76f8\u5173\u4fe1\u606f"})
public class ProductLevelController {
    private static final Logger log = LoggerFactory.getLogger(ProductLevelController.class);
    @Autowired(required=false)
    private ProductLevelService productLevelService;

    @PostMapping(value={"findByConditions"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    public Result<Page<ProductLevelCodeVo>> findByConditions(@PageableDefault(value=50) Pageable pageable, @ApiParam(value="\u5206\u9875\u53c2\u6570") ProductLevelDto productLevelDto) {
        try {
            Page<ProductLevelCodeVo> page = this.productLevelService.findByConditions(pageable, productLevelDto);
            return Result.ok(page);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"create"})
    @ApiOperation(value="\u4fee\u6539\u6216\u65b0\u589e\u4ea7\u54c1\u5c42\u7ea7")
    public Result<?> saveOrUpdate(@ApiParam(value="\u540c\u6b65\u4ea7\u54c1\u5c42\u7ea7\u53c2\u6570") @RequestBody List<ProductLevelEditDto> dtos) {
        try {
            this.productLevelService.create(dtos);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @DeleteMapping(value={"delete"})
    @ApiOperation(value="\u5220\u9664\u4ea7\u54c1\u5c42\u7ea7")
    public Result<?> deleteById(@RequestBody List<String> ids) {
        try {
            this.productLevelService.deleteByIds(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f!");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PatchMapping(value={"update"})
    @ApiOperation(value="\u4fee\u6539\u4ea7\u54c1\u5c42\u7ea7")
    public Result<?> updateById(@RequestBody List<ProductLevelEditDto> dtos) {
        try {
            this.productLevelService.updateById(dtos);
            return Result.ok((String)"\u4fee\u6539\u6210\u529f!");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

