/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.product.level.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.product.level.sdk.dto.ProductLevelDto;
import com.biz.crm.mdm.business.product.level.sdk.dto.RelateProductLevelCodeQueryDto;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4ea7\u54c1\u5c42\u7ea7\uff1aProductLevelVo\uff1a\u4e0e\u4ea7\u54c1\u5c42\u7ea7\u76f8\u5173\u7684\u5185\u5bb9"})
@RestController
@RequestMapping(value={"/v1/productLevel/productLevel"})
public class ProductLevelVoSdkController {
    private static final Logger log = LoggerFactory.getLogger(ProductLevelVoSdkController.class);
    @Autowired(required=false)
    private ProductLevelVoSdkService productLevelVoSdkService;

    @ApiOperation(value="\u6839\u636e\u5c42\u7ea7\u7f16\u7801\u83b7\u53d6\u5546\u54c1\u5c42\u7ea7\u660e\u7ec6\u4fe1\u606f")
    @GetMapping(value={"/findListByCodes"})
    public Result<List<ProductLevelVo>> findListByCodes(@RequestParam(value="codes") List<String> codes) {
        try {
            List list = this.productLevelVoSdkService.findListByCodes(codes);
            return Result.ok((Object)list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6309\u7167ProductLevel\u7684productLevelCode\u7f16\u7801\uff0c\u67e5\u8be2\u6240\u6709\u7684\u7236\u8282\u70b9\u4fe1\u606f")
    @GetMapping(value={"/findAllParentsByProductLevelCode"})
    public Result<List<ProductLevelVo>> findAllParentsByProductLevelCode(@RequestParam(value="productLevelCode") String productLevelCode) {
        try {
            List list = this.productLevelVoSdkService.findAllParentsByProductLevelCode(productLevelCode);
            return Result.ok((Object)list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u4ea7\u54c1\u5c42\u7ea7\u7c7b\u578b\u83b7\u53d6\u4ea7\u54c1\u5c42\u7ea7\u4fe1\u606f")
    @GetMapping(value={"/findByProductLevelType"})
    public Result<List<ProductLevelVo>> findByProductLevelType(@RequestParam(value="productLevelType") String productLevelType) {
        try {
            List list = this.productLevelVoSdkService.findByProductLevelType(productLevelType);
            return Result.ok((Object)list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4ea7\u54c1\u5c42\u7ea7\u7f16\u7801\u96c6\u5408\u83b7\u53d6\u5f53\u524d\u7f16\u7801\u5bf9\u5e94\u7684\u4ea7\u54c1\u5c42\u7ea7\u4ee5\u53ca\u5176\u4e0a\u7ea7\u4ea7\u54c1\u5c42\u7ea7")
    @GetMapping(value={"/findCurAndParentByCodes"})
    public Result<Map<String, List<ProductLevelVo>>> findCurAndParentByCodes(@RequestParam(value="codes") List<String> codes) {
        try {
            Map map = this.productLevelVoSdkService.findCurAndParentByCodes(codes);
            return Result.ok((Object)map);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4ea7\u54c1\u5c42\u7ea7\u7f16\u7801\u96c6\u5408\u83b7\u53d6\u5f53\u524d\u7f16\u7801\u5bf9\u5e94\u7684\u4ea7\u54c1\u5c42\u7ea7\u4ee5\u53ca\u5176\u4e0b\u7ea7\u4ea7\u54c1\u5c42\u7ea7")
    @GetMapping(value={"/findCurAndChildrenCodesByCodes"})
    public Result<List<String>> findCurAndChildrenCodesByCodes(@RequestParam(value="codes") Set<String> productLevelCodeSet) {
        try {
            List curAndChildrenCodesByCodes = this.productLevelVoSdkService.findCurAndChildrenCodesByCodes(productLevelCodeSet);
            return Result.ok((Object)curAndChildrenCodesByCodes);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u4ea7\u54c1\u5c42\u7ea7\u5bf9\u5e94\u7684\u672a\u5220\u9664\u7684\u4e0a\u7ea7\u6216\u4e0b\u7ea7\u7f16\u7801")
    @GetMapping(value={"/findByRelateProductLevelCodeQueryDto"})
    public Result<Map<String, String>> findByRelateProductLevelCodeQueryDto(RelateProductLevelCodeQueryDto dto) {
        try {
            return Result.ok((Object)this.productLevelVoSdkService.findByRelateProductLevelCodeQueryDto(dto));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"/findLeafChild"})
    @ApiOperation(value="\u83b7\u53d6\u4ea7\u54c1\u5c42\u7ea7\u53f6\u5b50\u8282\u70b9\u4e0b\u62c9\u6570\u636e")
    public Result<List<ProductLevelVo>> findLeafChild(@RequestBody ProductLevelDto dto) {
        try {
            return Result.ok((Object)this.productLevelVoSdkService.findLeafChild(dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"findByCodeAndName"})
    @ApiOperation(value="\u6839\u636e\u4ea7\u54c1\u7f16\u7801\u548c\u4ea7\u54c1\u540d\u79f0\u67e5\u8be2")
    public Result<List<ProductLevelVo>> findByCodeAndName(@RequestBody ProductLevelDto dto) {
        try {
            List list = this.productLevelVoSdkService.findByCodeAndName(dto);
            return Result.ok((Object)list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

