/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.product.level.local.notifier;

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.mdm.business.product.level.sdk.event.ProductLevelEventListener;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProductLevelEventLogListenerImpl
implements ProductLevelEventListener {
    private static final Logger log = LoggerFactory.getLogger(ProductLevelEventLogListenerImpl.class);
    @Autowired(required=false)
    private CrmBusinessLogVoService crmBusinessLogVoService;

    public void onBatchCreate(List<ProductLevelVo> productLevelVos) {
        log.info("\u65b0\u589e\u4ea7\u54c1\u5c42\u7ea7\u4fe1\u606f\uff1a{}", (Object)JsonUtils.obj2JsonString(productLevelVos));
        if (CollectionUtils.isEmpty(productLevelVos)) {
            return;
        }
        productLevelVos.forEach(productLevelVo -> {
            String onlyKey = productLevelVo.getId();
            CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
            crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
            crmBusinessLogDto.setOnlyKey(onlyKey);
            crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setOldObject(null);
            crmBusinessLogDto.setNewObject(productLevelVo);
            this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
        });
    }

    public void onBatchUpdate(List<ProductLevelVo> productLevelVos) {
        log.info("\u66f4\u65b0\u4ea7\u54c1\u5c42\u7ea7\u4fe1\u606f\uff1a{}", (Object)JsonUtils.obj2JsonString(productLevelVos));
        if (CollectionUtils.isNotEmpty(productLevelVos) && productLevelVos.size() > 1) {
            ProductLevelVo oldObj = productLevelVos.get(0);
            ProductLevelVo newObj = productLevelVos.get(1);
            String onlyKey = newObj.getId();
            CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
            crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
            crmBusinessLogDto.setOnlyKey(onlyKey);
            crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setOldObject((Object)oldObj);
            crmBusinessLogDto.setNewObject((Object)newObj);
            this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
        }
    }

    public void onBatchDelete(List<ProductLevelVo> productLevelVos) {
        log.info("\u5220\u9664\u4ea7\u54c1\u5c42\u7ea7\u4fe1\u606f\uff1a{}", (Object)JsonUtils.obj2JsonString(productLevelVos));
        if (CollectionUtils.isEmpty(productLevelVos)) {
            return;
        }
        productLevelVos.forEach(productLevelVo -> {
            String onlyKey = productLevelVo.getId();
            CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
            crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
            crmBusinessLogDto.setOnlyKey(onlyKey);
            crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setOldObject(productLevelVo);
            crmBusinessLogDto.setNewObject(null);
            this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
        });
    }

    public void onBatchEnable(List<ProductLevelVo> productLevelVos) {
        log.info("\u542f\u7528\u4ea7\u54c1\u5c42\u7ea7\u4fe1\u606f\uff1a{}", (Object)JsonUtils.obj2JsonString(productLevelVos));
        if (CollectionUtils.isEmpty(productLevelVos)) {
            return;
        }
        productLevelVos.forEach(productLevelVo -> {
            String onlyKey = productLevelVo.getId();
            ProductLevelVo oldObj = new ProductLevelVo();
            oldObj.setId(onlyKey);
            oldObj.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            ProductLevelVo newObj = new ProductLevelVo();
            newObj.setId(onlyKey);
            newObj.setEnableStatus(productLevelVo.getEnableStatus());
            CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
            crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
            crmBusinessLogDto.setOnlyKey(onlyKey);
            crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
            crmBusinessLogDto.setOldObject((Object)oldObj);
            crmBusinessLogDto.setNewObject((Object)newObj);
            this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
        });
    }

    public void onBatchDisable(List<ProductLevelVo> productLevelVos) {
        log.info("\u7981\u7528\u4ea7\u54c1\u5c42\u7ea7\u4fe1\u606f\uff1a{}", (Object)JsonUtils.obj2JsonString(productLevelVos));
        if (CollectionUtils.isNotEmpty(productLevelVos)) {
            productLevelVos.forEach(productLevelVo -> {
                String onlyKey = productLevelVo.getId();
                ProductLevelVo oldObj = new ProductLevelVo();
                oldObj.setId(onlyKey);
                oldObj.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                ProductLevelVo newObj = new ProductLevelVo();
                newObj.setId(onlyKey);
                newObj.setEnableStatus(productLevelVo.getEnableStatus());
                CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
                crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
                crmBusinessLogDto.setOnlyKey(onlyKey);
                crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
                crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
                crmBusinessLogDto.setOldObject((Object)oldObj);
                crmBusinessLogDto.setNewObject((Object)newObj);
                this.crmBusinessLogVoService.handleSave(crmBusinessLogDto);
            });
        }
    }
}

