/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.product.level.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.TenantFlagTreeOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.dto.TreeDto;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.vo.LazyTreeVo;
import com.biz.crm.mdm.business.product.level.local.entity.ProductLevel;
import com.biz.crm.mdm.business.product.level.local.mapper.ProductLevelMapper;
import com.biz.crm.mdm.business.product.level.sdk.dto.ProductLevelDto;
import com.biz.crm.mdm.business.product.level.sdk.dto.ProductLevelPaginationDto;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelCodeVo;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ProductLevelRepository
extends ServiceImpl<ProductLevelMapper, ProductLevel> {
    public Page<ProductLevelVo> findByConditions(Pageable pageable, ProductLevelPaginationDto productLevelPaginationDto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        productLevelPaginationDto.setTenantCode(TenantUtils.getTenantCode());
        return ((ProductLevelMapper)this.baseMapper).findByConditions((Page<ProductLevelVo>)page, productLevelPaginationDto, DelFlagStatusEnum.NORMAL);
    }

    public ProductLevel findDetailsById(String id) {
        return (ProductLevel)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidEntity::getId, (Object)id)).one());
    }

    public ProductLevel findDetailsByCode(String code) {
        return (ProductLevel)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(ProductLevel::getProductLevelCode, (Object)code)).one());
    }

    public List<ProductLevel> findDetailsByCodes(Set<String> codeSet) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(ProductLevel::getProductLevelCode, codeSet)).list();
    }

    public List<ProductLevel> findListByCode(String code) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(ProductLevel::getProductLevelCode, (Object)code)).list();
    }

    public List<ProductLevel> findChildrenListByParentCode(String parentCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).isNull(!StringUtils.isNotEmpty((CharSequence)parentCode), ProductLevel::getParentCode)).eq(StringUtils.isNotEmpty((CharSequence)parentCode), ProductLevel::getParentCode, (Object)parentCode)).list();
    }

    public List<ProductLevel> findListByIds(List<String> ids) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(UuidEntity::getId, ids)).list();
    }

    public List<ProductLevel> findListByRuleCodes(Set<String> ruleCodes) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(TenantFlagTreeOpEntity::getRuleCode, ruleCodes)).list();
    }

    public List<ProductLevel> findCurAndChildrenByRuleCodeList(List<String> ruleCodes, String enableStatus) {
        return ((ProductLevelMapper)this.baseMapper).findCurAndChildrenByRuleCodeList(ruleCodes, enableStatus, TenantUtils.getTenantCode(), DelFlagStatusEnum.NORMAL);
    }

    public List<ProductLevel> findChildrenListByParentCodes(List<String> parentCodes) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(ProductLevel::getParentCode, parentCodes)).list();
    }

    public void updateOrphanParentCodeNull() {
        ((ProductLevelMapper)this.baseMapper).updateOrphanParentCodeNull(TenantUtils.getTenantCode(), DelFlagStatusEnum.NORMAL);
    }

    public List<ProductLevel> findListWithoutParentCode() {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).isNull(ProductLevel::getParentCode)).list();
    }

    public List<ProductLevel> findListByCodes(List<String> codes) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(ProductLevel::getProductLevelCode, codes)).list();
    }

    public List<ProductLevel> findCurAndChildrenByRuleCode(String ruleCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).likeRight(TenantFlagTreeOpEntity::getRuleCode, (Object)ruleCode)).list();
    }

    public List<ProductLevel> findAll() {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public List<ProductLevel> findListLikeName(String enableStatus, String name) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(StringUtils.isNotEmpty((CharSequence)enableStatus), UuidFlagOpEntity::getEnableStatus, (Object)enableStatus)).like(StringUtils.isNotEmpty((CharSequence)name), ProductLevel::getProductLevelName, (Object)name)).list();
    }

    public List<ProductLevel> findListLikeName(TreeDto dto) {
        dto = Optional.ofNullable(dto).orElse(new TreeDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        return ((ProductLevelMapper)this.baseMapper).findListLikeName(dto);
    }

    public List<LazyTreeVo> findLazyTreeList(String enableStatus, Boolean topOnly, String parentCode, List<String> codeList, List<String> ruleCodeList, String excludeRuleCode) {
        return ((ProductLevelMapper)this.baseMapper).findLazyTreeList(enableStatus, topOnly, parentCode, codeList, ruleCodeList, excludeRuleCode, TenantUtils.getTenantCode(), DelFlagStatusEnum.NORMAL);
    }

    public void setParentCodeNull(String id) {
        ((ProductLevelMapper)this.baseMapper).setParentCodeNull(id, TenantUtils.getTenantCode());
    }

    public void setParentCodeAndRuleCodeNull(String id) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(ProductLevel::getParentCode, null)).set(TenantFlagTreeOpEntity::getRuleCode, (Object)"")).eq(UuidEntity::getId, (Object)id)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).update();
    }

    public List<ProductLevel> findByProductLevelType(String productLevelType, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(ProductLevel::getProductLevelType, (Object)productLevelType)).list();
    }

    public List<String> findCodeByCurAndChildrenByRuleCodes(Set<String> ruleCodeSet, String tenantCode) {
        if (CollectionUtils.isEmpty(ruleCodeSet)) {
            return Lists.newLinkedList();
        }
        return ((ProductLevelMapper)this.baseMapper).findCodeByCurAndChildrenByRuleCodes(ruleCodeSet, tenantCode, DelFlagStatusEnum.NORMAL.getCode());
    }

    public void updateBatchByIdAndTenantCode(List<ProductLevel> productLevelList, String tenantCode) {
        productLevelList.stream().forEach(productLevel -> {
            LambdaUpdateWrapper lambdaUpdateWrapper = Wrappers.lambdaUpdate();
            lambdaUpdateWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
            lambdaUpdateWrapper.in(UuidEntity::getId, new Object[]{productLevel.getId()});
            ((ProductLevelMapper)this.baseMapper).update(productLevel, (Wrapper)lambdaUpdateWrapper);
        });
    }

    public void updateByIdAndTenantCode(ProductLevel productLevel, String tenantCode) {
        LambdaUpdateWrapper lambdaUpdateWrapper = Wrappers.lambdaUpdate();
        lambdaUpdateWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
        lambdaUpdateWrapper.in(UuidEntity::getId, new Object[]{productLevel.getId()});
        ((ProductLevelMapper)this.baseMapper).update((Object)productLevel, (Wrapper)lambdaUpdateWrapper);
    }

    public String findRuleCodeByProductLevelCode(String productLevelCode) {
        ProductLevel productLevel = (ProductLevel)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ProductLevel::getProductLevelCode, (Object)productLevelCode)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).select(new SFunction[]{TenantFlagTreeOpEntity::getRuleCode}).one());
        if (ObjectUtils.isNull((Object[])new Object[]{productLevel})) {
            return null;
        }
        return productLevel.getRuleCode();
    }

    public Page<ProductLevelCodeVo> findProductLevelByConditions(Pageable pageable, ProductLevelDto productLevelDto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        productLevelDto.setTenantCode(TenantUtils.getTenantCode());
        return ((ProductLevelMapper)this.baseMapper).findProductLevelByConditions((Page<ProductLevelVo>)page, productLevelDto, DelFlagStatusEnum.NORMAL);
    }

    public void deleteByIds(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public List<ProductLevelVo> findLeafChildren(ProductLevelDto dto) {
        return ((ProductLevelMapper)this.baseMapper).findLeafChildren(TenantUtils.getTenantCode(), dto);
    }

    public List<ProductLevel> findByCodeAndName(ProductLevelDto dto) {
        return ((ProductLevelMapper)this.baseMapper).findByCodeAndName(dto);
    }
}

