/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.product.level.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.product.level.local.entity.ProductLevel;
import com.biz.crm.mdm.business.product.level.local.repository.ProductLevelRepository;
import com.biz.crm.mdm.business.product.level.local.service.ProductLevelService;
import com.biz.crm.mdm.business.product.level.sdk.dto.ProductLevelDto;
import com.biz.crm.mdm.business.product.level.sdk.dto.ProductLevelEditDto;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelCodeVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProductLevelServiceImpl
implements ProductLevelService {
    @Autowired(required=false)
    private ProductLevelRepository productLevelRepository;

    @Override
    public Page<ProductLevelCodeVo> findByConditions(Pageable pageable, ProductLevelDto productLevelDto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        productLevelDto = Optional.ofNullable(productLevelDto).orElse(new ProductLevelDto());
        productLevelDto.setTenantCode(TenantUtils.getTenantCode());
        return this.productLevelRepository.findProductLevelByConditions(pageable, productLevelDto);
    }

    @Override
    @Transactional
    public void create(List<ProductLevelEditDto> dtos) {
        this.createForm(dtos);
    }

    @Override
    @Transactional
    public void deleteByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.productLevelRepository.deleteByIds(ids);
    }

    @Override
    @Transactional
    public void updateById(List<ProductLevelEditDto> dtos) {
        this.editForm(dtos);
    }

    private void editForm(List<ProductLevelEditDto> dtos) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(dtos), (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        dtos.stream().forEach(o -> {
            Validate.notBlank((CharSequence)o.getCode(), (String)"\u4ea7\u54c1\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)o.getName(), (String)"\u4ea7\u54c1\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)o.getParentId(), (String)"\u7236\u7c7bID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)o.getId(), (String)"\u8bf7\u6c42ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        });
        ArrayList list = new ArrayList();
        int levelNum = 1;
        dtos.stream().forEach(o -> {
            ProductLevel productLevel = new ProductLevel();
            productLevel.setParentId(o.getParentId());
            productLevel.setProductLevelCode(o.getCode());
            productLevel.setProductLevelName(o.getName());
            productLevel.setId(o.getId());
            if (o.getParentId().equals("-1")) {
                productLevel.setLevelNum(levelNum);
            } else {
                ProductLevel level = this.productLevelRepository.findDetailsById(o.getParentId());
                Validate.isTrue((level != null ? 1 : 0) != 0, (String)"\u4e0d\u5b58\u5728\u7684\u7236\u7c7bID", (Object[])new Object[0]);
                productLevel.setLevelNum(level.getLevelNum() + levelNum);
            }
            productLevel.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            productLevel.setTenantCode(TenantUtils.getTenantCode());
            productLevel.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            list.add(productLevel);
        });
        this.productLevelRepository.updateBatchById(list);
    }

    private void createForm(List<ProductLevelEditDto> dtos) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(dtos), (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        dtos.stream().forEach(o -> {
            Validate.notBlank((CharSequence)o.getCode(), (String)"\u4ea7\u54c1\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)o.getName(), (String)"\u4ea7\u54c1\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)o.getParentId(), (String)"\u7236\u7c7bID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        });
        ArrayList list = new ArrayList();
        int levelNum = 1;
        dtos.stream().forEach(o -> {
            ProductLevel productLevel = new ProductLevel();
            productLevel.setParentId(o.getParentId());
            productLevel.setProductLevelCode(o.getCode());
            productLevel.setProductLevelName(o.getName());
            ProductLevel level = this.productLevelRepository.findDetailsById(o.getParentId());
            productLevel.setId(o.getId());
            if (o.getParentId().equals("-1")) {
                productLevel.setLevelNum(levelNum);
            } else {
                productLevel.setLevelNum(level.getLevelNum() + levelNum);
            }
            productLevel.setRuleCode(o.getCode());
            productLevel.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            productLevel.setTenantCode(TenantUtils.getTenantCode());
            productLevel.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            list.add(productLevel);
        });
        this.productLevelRepository.saveOrUpdateBatch(list);
    }
}

