/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.product.level.local.service.internal;

import com.biz.crm.business.common.local.entity.TenantFlagTreeOpEntity;
import com.biz.crm.business.common.sdk.dto.TreeDto;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategy;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategyHolder;
import com.biz.crm.business.common.sdk.utils.TreeUtil;
import com.biz.crm.business.common.sdk.vo.TreeVo;
import com.biz.crm.mdm.business.product.level.local.entity.ProductLevel;
import com.biz.crm.mdm.business.product.level.local.repository.ProductLevelRepository;
import com.biz.crm.mdm.business.product.level.local.service.ProductLevelTreeVoService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ProductLevelTreeVoServiceImpl
implements ProductLevelTreeVoService {
    @Autowired(required=false)
    private ProductLevelRepository productLevelRepository;
    @Autowired(required=false)
    private TreeRuleCodeStrategyHolder treeRuleCodeStrategyHolder;

    @Override
    public List<TreeVo> findTree(Pageable pageable, TreeDto treeDto) {
        TreeRuleCodeStrategy treeRuleCodeStrategy;
        Set set;
        treeDto = Optional.ofNullable(treeDto).orElse(new TreeDto());
        List<Object> tree = new ArrayList<TreeVo>();
        List<ProductLevel> list = this.productLevelRepository.findListLikeName(treeDto);
        if (CollectionUtils.isEmpty(list)) {
            return tree;
        }
        if (StringUtils.isNotEmpty((CharSequence)treeDto.getName()) && !CollectionUtils.isEmpty((Collection)(set = (treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null)).findParentRuleCodeByRuleCodes(3, list.stream().map(TenantFlagTreeOpEntity::getRuleCode).collect(Collectors.toList()))))) {
            List partition = Lists.partition(new ArrayList(set), (int)500);
            list = new ArrayList<ProductLevel>();
            for (List part : partition) {
                list.addAll(this.productLevelRepository.findListByRuleCodes(new HashSet<String>(part)));
            }
        }
        List collect = list.stream().map(x -> {
            TreeVo treeVo = new TreeVo();
            treeVo.setId(x.getId());
            treeVo.setParentCode(x.getParentCode());
            treeVo.setCode(x.getProductLevelCode());
            treeVo.setName(x.getProductLevelName());
            return treeVo;
        }).collect(Collectors.toList());
        tree = TreeUtil.generateTreeByParentCode(collect);
        if (StringUtils.isNotEmpty((CharSequence)treeDto.getExcludeCodeAndChildren())) {
            TreeUtil.excludeCodeAndChildren(tree, (String)treeDto.getExcludeCodeAndChildren());
        }
        return tree;
    }
}

