/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.product.level.local.service.internal;

import com.biz.crm.business.common.local.entity.TenantFlagTreeOpEntity;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategy;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategyHolder;
import com.biz.crm.mdm.business.product.level.local.entity.ProductLevel;
import com.biz.crm.mdm.business.product.level.local.repository.ProductLevelRepository;
import com.biz.crm.mdm.business.product.level.local.service.ProductLevelVoService;
import com.biz.crm.mdm.business.product.level.sdk.dto.ProductLevelDto;
import com.biz.crm.mdm.business.product.level.sdk.dto.RelateProductLevelCodeQueryDto;
import com.biz.crm.mdm.business.product.level.sdk.service.ProductLevelVoSdkService;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ProductLevelVoSdkServiceImpl
implements ProductLevelVoSdkService {
    @Autowired(required=false)
    private ProductLevelVoService productLevelVoService;
    @Autowired(required=false)
    private ProductLevelRepository productLevelRepository;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private TreeRuleCodeStrategyHolder treeRuleCodeStrategyHolder;

    public ProductLevelVo findDetailsById(String id) {
        return this.productLevelVoService.findDetailsById(id);
    }

    public List<ProductLevelVo> findListByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<ProductLevelVo>();
        }
        List<ProductLevel> productLevels = this.productLevelRepository.findListByIds(ids);
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(productLevels, ProductLevel.class, ProductLevelVo.class, HashSet.class, ArrayList.class, new String[0]));
    }

    public ProductLevelVo findDetailsByCode(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        ProductLevel productLevel = this.productLevelRepository.findDetailsByCode(code);
        if (null == productLevel) {
            return null;
        }
        return (ProductLevelVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)productLevel, ProductLevelVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<ProductLevelVo> findAllParentsByProductLevelCode(String productLevelCode) {
        ArrayList<ProductLevelVo> list = new ArrayList<ProductLevelVo>();
        if (StringUtils.isEmpty((CharSequence)productLevelCode)) {
            return new ArrayList<ProductLevelVo>();
        }
        ProductLevel productLevel = this.productLevelRepository.findDetailsByCode(productLevelCode);
        if (productLevel != null) {
            Set<String> ruleCodes = this.splitParentRuleCodes(productLevel.getRuleCode(), "|");
            List<ProductLevel> productLevels = this.productLevelRepository.findListByRuleCodes(ruleCodes);
            list.addAll(Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(productLevels, ProductLevel.class, ProductLevelVo.class, HashSet.class, ArrayList.class, new String[0])));
        }
        return list;
    }

    public List<ProductLevelVo> findListByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return new ArrayList<ProductLevelVo>();
        }
        List<ProductLevel> productLevels = this.productLevelRepository.findListByCodes(codes);
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(productLevels, ProductLevel.class, ProductLevelVo.class, HashSet.class, ArrayList.class, new String[0]));
    }

    public List<String> findCurAndChildrenCodesByCodes(Set<String> productLevelCodeSet) {
        return this.productLevelVoService.findCurAndChildrenCodesByCodes(productLevelCodeSet);
    }

    public List<ProductLevelVo> findByProductLevelType(String productLevelType) {
        if (StringUtils.isBlank((CharSequence)productLevelType)) {
            return Lists.newLinkedList();
        }
        List<ProductLevel> productLevels = this.productLevelRepository.findByProductLevelType(productLevelType, TenantUtils.getTenantCode());
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(productLevels, ProductLevel.class, ProductLevelVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public Map<String, List<ProductLevelVo>> findCurAndParentByCodes(List<String> codes) {
        Map<Object, Object> resultMap = Maps.newHashMap();
        if (CollectionUtils.isEmpty(codes)) {
            return resultMap;
        }
        List<ProductLevel> productLevels = this.productLevelRepository.findListByCodes(codes);
        if (CollectionUtils.isEmpty(productLevels)) {
            return resultMap;
        }
        resultMap = productLevels.stream().collect(Collectors.toMap(ProductLevel::getProductLevelCode, t -> {
            ProductLevelVo vo = (ProductLevelVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)t, ProductLevelVo.class, HashSet.class, ArrayList.class, new String[0]);
            return Lists.newArrayList((Object[])new ProductLevelVo[]{vo});
        }, (a, b) -> b));
        List ruleCodes = productLevels.stream().map(TenantFlagTreeOpEntity::getRuleCode).collect(Collectors.toList());
        TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
        Set parentRuleCodes = treeRuleCodeStrategy.findParentRuleCodesByRuleCodesExcludeSelf(3, ruleCodes);
        if (CollectionUtils.isEmpty((Collection)parentRuleCodes)) {
            return resultMap;
        }
        List<ProductLevel> parentList = this.productLevelRepository.findListByRuleCodes(parentRuleCodes);
        if (CollectionUtils.isEmpty(parentList)) {
            return resultMap;
        }
        Map<String, ProductLevelVo> parentMap = parentList.stream().collect(Collectors.toMap(TenantFlagTreeOpEntity::getRuleCode, t -> (ProductLevelVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)t, ProductLevelVo.class, HashSet.class, ArrayList.class, new String[0]), (a, b) -> b));
        resultMap.values().forEach(productLevelVos -> {
            ProductLevelVo productLevelVo = (ProductLevelVo)productLevelVos.get(0);
            Set pRoleCodes = treeRuleCodeStrategy.findParentRuleCodesByRuleCodeExcludeSelf(3, productLevelVo.getRuleCode());
            pRoleCodes.forEach(ruleCode -> {
                ProductLevelVo levelVo = (ProductLevelVo)parentMap.get(ruleCode);
                if (Objects.nonNull(levelVo)) {
                    productLevelVos.add(levelVo);
                }
            });
        });
        return resultMap;
    }

    public Map<String, String> findByRelateProductLevelCodeQueryDto(RelateProductLevelCodeQueryDto dto) {
        if (Objects.isNull(dto) || CollectionUtils.isEmpty((Collection)dto.getProductLevelCodeSet())) {
            return Maps.newHashMap();
        }
        dto.setSearchType(Optional.ofNullable(dto.getSearchType()).orElse(0));
        List<ProductLevel> productLevelList = this.productLevelRepository.findDetailsByCodes(dto.getProductLevelCodeSet());
        if (CollectionUtils.isEmpty(productLevelList)) {
            return Maps.newHashMap();
        }
        if (dto.getSearchType() == 0) {
            return productLevelList.stream().filter(a -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{a.getProductLevelCode(), a.getRuleCode()})).collect(Collectors.toMap(ProductLevel::getProductLevelCode, TenantFlagTreeOpEntity::getRuleCode, (a, b) -> a));
        }
        List<String> ruleCodeList = productLevelList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getRuleCode())).map(TenantFlagTreeOpEntity::getRuleCode).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ruleCodeList)) {
            return Maps.newHashMap();
        }
        TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
        if (dto.getSearchType() > 0) {
            Set ruleCodeSet = treeRuleCodeStrategy.findParentRuleCodesByRuleCodesExcludeSelf(3, ruleCodeList);
            if (CollectionUtils.isEmpty((Collection)ruleCodeSet)) {
                ruleCodeSet = Sets.newHashSet();
            }
            ruleCodeSet.addAll(ruleCodeList);
            if (CollectionUtils.isNotEmpty((Collection)ruleCodeSet)) {
                List<ProductLevel> cur = this.productLevelRepository.findListByRuleCodes(ruleCodeSet);
                if (CollectionUtils.isEmpty(cur)) {
                    return Maps.newHashMap();
                }
                return cur.stream().collect(Collectors.toMap(ProductLevel::getProductLevelCode, TenantFlagTreeOpEntity::getRuleCode, (a, b) -> a));
            }
        } else {
            List<ProductLevel> cur = this.productLevelRepository.findCurAndChildrenByRuleCodeList(ruleCodeList, null);
            if (CollectionUtils.isEmpty(cur)) {
                return Maps.newHashMap();
            }
            return cur.stream().collect(Collectors.toMap(ProductLevel::getProductLevelCode, TenantFlagTreeOpEntity::getRuleCode, (a, b) -> a));
        }
        return Maps.newHashMap();
    }

    public List<ProductLevelVo> findLeafChild(ProductLevelDto dto) {
        List<ProductLevelVo> leafChildren = this.productLevelRepository.findLeafChildren(dto);
        if (CollectionUtils.isEmpty(leafChildren)) {
            return Lists.newArrayList();
        }
        return leafChildren;
    }

    public List<ProductLevelVo> findByCodeAndName(ProductLevelDto dto) {
        List<ProductLevel> list = this.productLevelRepository.findByCodeAndName(dto);
        return (List)this.nebulaToolkitService.copyCollectionByBlankList(list, ProductLevel.class, ProductLevelVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private Set<String> splitParentRuleCodes(String ruleCode, String separator) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (StringUtils.isNotEmpty((CharSequence)ruleCode)) {
            set.add(ruleCode);
            String[] codes = StringUtils.split((String)ruleCode, (String)separator);
            for (int i = 1; i < codes.length; ++i) {
                String subRuleCode = Arrays.stream(codes).limit(i).collect(Collectors.joining(separator)) + separator;
                set.add(subRuleCode);
            }
        }
        return set;
    }
}

