package com.biz.crm.mdm.business.product.level.sdk.service;
/**
 * Created by Bao Hongbin on 2021-10-14 14:45.
 */

import com.biz.crm.mdm.business.product.level.sdk.dto.ProductLevelDto;
import com.biz.crm.mdm.business.product.level.sdk.dto.RelateProductLevelCodeQueryDto;
import com.biz.crm.mdm.business.product.level.sdk.vo.ProductLevelVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @program: crm
 * @description: 产品层级vo SDK 服务
 * @author: Bao Hongbin
 * @create: 2021-10-14 14:45
 **/
public interface ProductLevelVoSdkService {

  /**
   * 通过id查询产品层级
   *
   * @param id
   * @return
   */
  ProductLevelVo findDetailsById(String id);


  /**
   * 通过ids查询产品层级
   *
   * @param ids
   * @return
   */
  List<ProductLevelVo> findListByIds(List<String> ids);

  /**
   * 通过code查询产品层级
   *
   * @param code
   * @return
   */
  ProductLevelVo findDetailsByCode(String code);

  /**
   * 按照ProductLevel的productLevelCode编码，查询所有的父节点信息
   *
   * @param productLevelCode
   * @return
   */
    List<ProductLevelVo> findAllParentsByProductLevelCode(String productLevelCode);


  /**
   * 通过codes查询产品层级
   *
   * @param codes
   * @return
   */
  List<ProductLevelVo> findListByCodes(List<String> codes);


  /**
   * 根据产品层级编码集合查询该产品层级及全部下级层级的编码
   *
   * @param productLevelCodeSet
   * @return
   */
  List<String> findCurAndChildrenCodesByCodes(Set<String> productLevelCodeSet);


  /**
   * 根据产品层级类型获取产品层级信息
   *
   * @param productLevelType 产品层级类型
   * @return 产品层级信息
   */
  default List<ProductLevelVo> findByProductLevelType(String productLevelType) {
    return Lists.newLinkedList();
  }

  /**
   * 通过产品层级编码集合获取当前编码对应的产品层级以及其上级产品层级
   *
   * @param codes 产品层级编码
   * @return 产品层级映射(key_产品层级编码,value_当前编码对应的产品层级以及其上级产品层级列表)
   */
  default Map<String, List<ProductLevelVo>> findCurAndParentByCodes(List<String> codes) {
    return Maps.newHashMap();
  }

  /**
   * 获取产品层级对应的未删除的上级或下级编码
   *
   * @param dto
   * @return
   */
  default Map<String, String> findByRelateProductLevelCodeQueryDto(
      RelateProductLevelCodeQueryDto dto) {
    return Maps.newHashMap();
  }

  /***
   * 获取产品层级叶子节点
   * @return
   */
  List<ProductLevelVo> findLeafChild(ProductLevelDto dto);

  List<ProductLevelVo> findByCodeAndName(ProductLevelDto dto);
}
