package com.biz.crm.mdm.business.product.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 商品主表实体
 *
 * @author sunx
 * @date 2021/10/12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("mdm_product")
@Api(tags = "商品主表实体")
@Table(
    name = "mdm_product",
    indexes = {
      @Index(name = "mdm_product_index1", columnList = "tenant_code,product_code", unique = true),
      @Index(name = "mdm_product_index2", columnList = "product_level_code")
    })
@org.hibernate.annotations.Table(appliesTo = "mdm_product", comment = "商品主表")
public class Product extends TenantFlagOpEntity {
  private static final long serialVersionUID = 2274980263975908479L;

  @ApiModelProperty("商品编码")
  @TableField(value = "product_code")
  @Column(name = "product_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '商品编码'")
  private String productCode;

  @ApiModelProperty("商品名称")
  @TableField(value = "product_name")
  @Column(name = "product_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '商品名称'")
  private String productName;

  @ApiModelProperty("产品层级编码")
  @TableField(value = "product_level_code")
  @Column(
      name = "product_level_code",
      length = 64,
      columnDefinition = "VARCHAR(64) COMMENT '产品层级编码'")
  private String productLevelCode;

  @ApiModelProperty("产品层级")
  @TableField(exist = false)
  @Transient
  private String productLevelName;

  @ApiModelProperty("商品类型")
  @TableField(value = "product_type")
  @Column(name = "product_type", length = 64, columnDefinition = "VARCHAR(64) COMMENT '商品类型'")
  private String productType;

  @ApiModelProperty("销售单位")
  @TableField(value = "sale_unit")
  @Column(name = "sale_unit", length = 64, columnDefinition = "VARCHAR(64) COMMENT '销售单位'")
  private String saleUnit;

  @ApiModelProperty("规格")
  @TableField(value = "spec")
  @Column(name = "spec", length = 64, columnDefinition = "VARCHAR(64) COMMENT '规格'")
  private String spec;

  @ApiModelProperty("基本单位")
  @TableField(value = "base_unit")
  @Column(name = "base_unit", length = 64, columnDefinition = "VARCHAR(64) COMMENT '基本单位'")
  private String baseUnit;

  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @ApiModelProperty("开始时间")
  @TableField(value = "begin_date_time")
  @Column(name = "begin_date_time", columnDefinition = "datetime COMMENT '开始时间'")
  private Date beginDateTime;

  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @ApiModelProperty("结束时间")
  @TableField(value = "end_date_time")
  @Column(name = "end_date_time", columnDefinition = "datetime COMMENT '结束时间'")
  private Date endDateTime;

  @ApiModelProperty("上下架状态")
  @TableField(value = "is_shelf")
  @Column(name = "is_shelf", length = 64, columnDefinition = "VARCHAR(64) COMMENT '上下架状态'")
  private String isShelf;

  @ApiModelProperty("条形码")
  @TableField(value = "bar_code")
  @Column(name = "bar_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '条形码'")
  private String barCode;

  @ApiModelProperty("是否维护图片")
  @TableField(value = "maintenance_picture")
  @Column(name = "maintenance_picture", columnDefinition = "int COMMENT '是否维护图片'")
  private Boolean maintenancePicture;

  @ApiModelProperty("是否维护详情")
  @TableField(value = "maintenance_introduction")
  @Column(name = "maintenance_introduction", columnDefinition = "int COMMENT '是否维护详情'")
  private Boolean maintenanceIntroduction;

  @ApiModelProperty("销售公司")
  @TableField(value = "sale_company")
  @Column(name = "sale_company", length = 64, columnDefinition = "VARCHAR(64) COMMENT '销售公司'")
  private String saleCompany;

  @ApiModelProperty("sfa图片地址")
  @TableField(value = "pic_url")
  @Column(name = "pic_url", length = 255, columnDefinition = "VARCHAR(255) COMMENT 'sfa图片地址'")
  private String picUrl;

  @ApiModelProperty("主图片url")
  @TableField(value = "primary_picture_url")
  @Column(
      name = "primary_picture_url",
      length = 255,
      columnDefinition = "VARCHAR(255) COMMENT '主图片url'")
  private String primaryPictureUrl;

  /** 商品介绍 */
  @TableField(exist = false)
  @Transient
  private ProductIntroduction introduction;

  /** 物料信息 */
  @TableField(exist = false)
  @Transient
  private List<ProductMaterial> materialList;

  /** 视频图片 */
  @TableField(exist = false)
  @Transient
  private List<ProductMedia> mediaList;
}
