package com.biz.crm.mdm.business.product.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 商品图片视频实体
 *
 * @author sunx
 * @date 2021/10/12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("mdm_product_media")
@ApiModel(value = "ProductMedia", description = "商品图片视频")
@Table(
    name = "mdm_product_media",
    indexes = {
      @Index(name = "mdm_product_media_index1", columnList = "tenant_code"),
      @Index(name = "mdm_product_media_index2", columnList = "product_code"),
      @Index(name = "mdm_product_media_index3", columnList = "type")
    })
@org.hibernate.annotations.Table(appliesTo = "mdm_product_media", comment = "商品图片视频表")
public class ProductMedia extends TenantEntity {
  private static final long serialVersionUID = -725190354592590536L;

  @ApiModelProperty("商品编码")
  @TableField(value = "product_code")
  @Column(name = "product_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '商品编码'")
  private String productCode;

  @ApiModelProperty("图片地址")
  @TableField(value = "url_address")
  @Column(name = "url_address", length = 255, columnDefinition = "VARCHAR(255) COMMENT '图片地址'")
  private String urlAddress;

  @ApiModelProperty("文件类型('picture'图片,'video'视频)")
  @TableField(value = "type")
  @Column(
      name = "type",
      length = 32,
      columnDefinition = "VARCHAR(32) COMMENT '文件类型(picture-图片,video-视频)'")
  private String type;

  @ApiModelProperty("文件名")
  @TableField(value = "file_name")
  @Column(name = "file_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '文件名'")
  private String fileName;

  @ApiModelProperty("原始文件名")
  @TableField(value = "original_file_name")
  @Column(
      name = "original_file_name",
      length = 128,
      columnDefinition = "VARCHAR(128) COMMENT '原始文件名'")
  private String originalFileName;

  @ApiModelProperty("文件路径")
  @TableField(value = "relative_local")
  @Column(name = "relative_local", length = 128, columnDefinition = "VARCHAR(128) COMMENT '文件路径'")
  private String relativeLocal;

  @ApiModelProperty("OSS文件对象名")
  @TableField(value = "object_name")
  @Column(name = "object_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT 'OSS文件对象名'")
  private String objectName;
}
