package com.biz.crm.mdm.business.product.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mdm.business.product.local.entity.ProductMedia;
import com.biz.crm.mdm.business.product.local.mapper.ProductMediaMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 商品图片视频表(repository)
 *
 * @author sunx
 * @since 2021-10-14 16:06:57
 */
@Component
public class ProductMediaRepository extends ServiceImpl<ProductMediaMapper, ProductMedia> {

  public List<ProductMedia> findByProductCodes(List<String> productCodeList) {
    return lambdaQuery()
        .eq(ProductMedia::getTenantCode, TenantUtils.getTenantCode())
        .in(ProductMedia::getProductCode, productCodeList)
        .list();
  }

  public void deleteByProductCodes(List<String> productCodes) {
    LambdaQueryWrapper<ProductMedia> lambdaQuery = Wrappers.lambdaQuery();
    lambdaQuery
        .eq(ProductMedia::getTenantCode, TenantUtils.getTenantCode())
        .in(ProductMedia::getProductCode, productCodes);
    baseMapper.delete(lambdaQuery);
  }
}
