package com.biz.crm.mdm.business.product.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.product.local.entity.Product;
import com.biz.crm.mdm.business.product.sdk.dto.ContractProductQueryDto;
import com.biz.crm.mdm.business.product.sdk.dto.ProductPaginationDto;
import java.util.List;
import java.util.Set;
import org.springframework.data.domain.Pageable;

/**
 * mdm_product 商品主数据(Product)表服务接口
 *
 * @author sunx
 * @since 2021-10-13 15:40:33
 */
public interface ProductService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<Product> findByConditions(Pageable pageable, ProductPaginationDto dto);

  /**
   * 根据id或编码集合获取商品集合
   *
   * @param ids
   * @param productCodes
   * @return
   */
  List<Product> findDetailsByIdsOrProductCodes(List<String> ids, List<String> productCodes);

  /**
   * 创建
   *
   * @param product
   * @return
   */
  Product create(Product product);

  /**
   * 更新
   *
   * @param product
   * @return
   */
  Product update(Product product);

  /**
   * 逻辑删除
   *
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);

  /**
   * 上架
   *
   * @param ids
   */
  void upShelf(List<String> ids);

  /**
   * 下架
   *
   * @param ids
   */
  void downShelf(List<String> ids);

  /**
   * 根据商品编码上架
   *
   * @param productCodeList
   */
  void upShelfByProductCodes(List<String> productCodeList);

  /**
   * 根据商品编码下架
   *
   * @param productCodeList
   */
  void downShelfByProductCodes(List<String> productCodeList);

  /**
   * 按id集合启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 按id集合禁用
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 根据商品层级编码或删除标获取匹配商品数量
   *
   * @param productLevelCodes
   * @param delFlag
   * @return
   */
  Integer countByProductLevelCodesAndDelFlag(List<String> productLevelCodes, String delFlag);

  /**
   * 获取商品对应的商品层级编码集合
   *
   * @param productCodeSet
   * @return
   */
  Set<String> findProductLevelCodeSetByProductCodes(Set<String> productCodeSet);

  /**
   * 通过商品编码查询
   *
   * @param code
   * @return
   */
  default Product findByProductCode(String code) {
    return null;
  }

  /**
   * 获取合同配置可购清单商品数据(商品编码+名称)
   *
   * @param dto 查询参数
   * @return
   */
  List<Product> findByContractProductQueryDto(ContractProductQueryDto dto);
}
