package com.biz.crm.mdm.business.product.local.service.internal;

import com.biz.crm.mdm.business.product.local.entity.ProductMedia;
import com.biz.crm.mdm.business.product.local.repository.ProductMediaRepository;
import com.biz.crm.mdm.business.product.local.service.ProductMediaService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Optional;

/**
 * 商品媒体信息
 *
 * @author sunx
 * @date 2021/10/14
 */
@Service("productMediaService")
public class ProductMediaServiceImpl implements ProductMediaService {

  @Autowired(required = false) private ProductMediaRepository productMediaRepository;

  @Override
  public List<ProductMedia> findByProductCodes(List<String> productCodeList) {
    if (CollectionUtils.isEmpty(productCodeList)) {
      return Lists.newLinkedList();
    }
    return productMediaRepository.findByProductCodes(productCodeList);
  }

  @Override
  @Transactional
  public void saveBatch(List<ProductMedia> productMediaList, String productCode) {
    Validate.notBlank(productCode, "商品编码不能为空");
    productMediaRepository.deleteByProductCodes(Lists.newArrayList(productCode));
    if (CollectionUtils.isEmpty(productMediaList)) {
      return;
    }
    Optional<ProductMedia> first =
        productMediaList.stream()
            .filter(
                a ->
                    StringUtils.isBlank(a.getProductCode())
                        || StringUtils.isBlank(a.getUrlAddress())
                        || !productCode.equals(a.getProductCode()))
            .findFirst();
    Validate.isTrue(!first.isPresent(), "商品编码或媒体信息不能为空,且必须属于同一商品");
    for (ProductMedia productMedia : productMediaList) {
      productMedia.setId(null);
      productMedia.setTenantCode(TenantUtils.getTenantCode());
    }
    productMediaRepository.saveBatch(productMediaList);
  }
}
